/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.GeneratorEvaluator;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.pdep.DimensionDependencySpec;
import com.dataiku.dip.recipes.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;

public class FlowRecipe
extends FlowRunnable {
    private SerializedRecipe model;
    private List<DimensionDependencySpec> partitionDeps = new ArrayList<DimensionDependencySpec>();

    public FlowRecipe(SerializedRecipe model) {
        this.model = model;
    }

    @Override
    public String getFullId() {
        return this.model.projectKey + "." + this.model.name;
    }

    @Override
    public String getGraphId() {
        return GraphIds.forRecipe(this);
    }

    @Override
    public String getName() {
        return this.model.name;
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getType() {
        return this.model.type;
    }

    @Override
    public String getProjectKey() {
        return this.model.projectKey;
    }

    public boolean isGenerator() {
        return RecipeRegistry.getMeta(this.model).isGenerator();
    }

    public GeneratorEvaluator getGeneratorEvaluator() {
        return RecipeRegistry.getMeta(this.model).getGeneratorEvaluator(this.model);
    }

    public boolean isNeverRecomputeExistingPartitions() {
        return this.model.neverRecomputeExistingPartitions;
    }

    public List<DimensionDependencySpec> getPartitionDeps() {
        return this.partitionDeps;
    }

    public void addPartitionDeps(DimensionDependencySpec dep) {
        this.partitionDeps.add(dep);
    }

    public SerializedRecipe getModel() {
        return this.model;
    }

    public void updateModel(SerializedRecipe sr) {
        this.model = sr;
    }

    public boolean mustStopRecursion() {
        return this.model.redispatchPartitioning;
    }
}

