/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.SimpleFlowView;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;

public class HiveModeView
extends SimpleFlowView {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.hive");

    public HiveModeView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public synchronized SimpleFlowView.SimpleFlowViewState computeState() throws Exception {
        this.state = new SimpleFlowView.SimpleFlowViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                String nodeId = GraphIds.forRecipe(sr.name);
                this.add(nodeId, sr);
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, SerializedRecipe sr) {
        try {
            if (HiveRecipeMeta.META.getType().equals(sr.getType())) {
                HiveRecipeMeta.HiveRecipeParams params = sr.getParamsAs(HiveRecipeMeta.HiveRecipeParams.class);
                String mode = params.executionEngine.toString();
                this.add(nodeId, mode);
            } else {
                RecipeMeta meta = RecipeRegistry.getMeta(sr);
                String payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name);
                if (payload == null) {
                    return;
                }
                RecipeStatusComputer cs2 = meta.buildStatusComputer(sr, payload);
                if (cs2 == null) {
                    return;
                }
                RecipeStatus status = cs2.fastStatusIgnorePartitions(this.authCtx);
                if (status == null) {
                    return;
                }
                RecipeEngineStatus engineStatus = status.selectedEngine;
                if (engineStatus == null || !"HIVE".equals(engineStatus.type)) {
                    return;
                }
                String mode = meta.getHiveEngine(sr, payload).toString();
                this.add(nodeId, mode);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get recipe settings", (Throwable)e);
        }
    }
}

