/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.postactions;

import com.dataiku.dip.dataflow.jobrunner.JobBackendLoggingContext;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.kernel.master.postactions.PostJobAction;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ReduceJobLogs
extends PostJobAction {
    @Autowired
    private FlowExecutionService2 flowExecutionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobs.postactions.logs");

    public ReduceJobLogs(String projectKey, String jobId) {
        super(projectKey, jobId);
    }

    @Override
    public void run() throws Exception {
        logger.debug((Object)("Executing post-action " + this.getClass().getSimpleName()));
        Params p = ProjectsUtils.getProjectDKUPropertiesAsParamsWithSystemOverrideEvenIfProjectDoesNotExist_AutoTXN(this.projectKey);
        if (!p.getBoolParam("dku.jobs.postActions.reduceJobLogs.enabled", true)) {
            logger.info((Object)"Not reducing job logs (requested by project property)");
            return;
        }
        boolean removeJobLog = p.getBoolParam("dku.jobs.postActions.reduceJobLogs.removeJobLog", true);
        long minSizeForActivityLogCompressionKB = p.getLongParam("dku.jobs.postActions.reduceJobLogs.minSizeForActivityLogCompressionKB", 200L);
        long minSizeForOutputLogCompressionKB = p.getLongParam("dku.jobs.postActions.reduceJobLogs.minSizeForOutputLogCompressionKB", 500L);
        long minSizeForLlmLogCompressionKB = p.getLongParam("dku.jobs.postActions.reduceJobLogs.minSizeForLlmLogCompressionKB", 500L);
        EnhancedSerializedJobStatus esjs = this.flowExecutionService.getStatus_NT(this.projectKey, this.jobId);
        for (Map.Entry<String, SerializedJobActivityStatus> activity : esjs.baseStatus.activities.entrySet()) {
            String activityId = activity.getKey();
            try {
                File activityLog = LogsService.getActivityLogFile(this.projectKey, this.jobId, activityId);
                ReduceJobLogs.compressFileIfNeeded(activityLog, minSizeForActivityLogCompressionKB, "activity");
                File llmActivityLog = LogsService.getActivityBackendLogFile(this.projectKey, this.jobId, activityId, JobBackendLoggingContext.Topic.LLM);
                ReduceJobLogs.compressFileIfNeeded(llmActivityLog, minSizeForLlmLogCompressionKB, "activity llm");
            }
            catch (IOException e) {
                logger.warn((Object)"Failure during activity log compression", (Throwable)e);
            }
        }
        File jobDotLog = LogsService.getJobDotLogFile(this.projectKey, this.jobId);
        if (removeJobLog && jobDotLog.isFile()) {
            logger.debug((Object)"Removing job.log");
            DKUFileUtils.forceDelete((File)jobDotLog);
        }
        File outputDotLog = LogsService.getOutputDotLogFile(this.projectKey, this.jobId);
        ReduceJobLogs.compressFileIfNeeded(outputDotLog, minSizeForOutputLogCompressionKB, "output.log");
        File llmDotLog = LogsService.getJobBackendLogFile(this.projectKey, this.jobId, JobBackendLoggingContext.Topic.LLM);
        ReduceJobLogs.compressFileIfNeeded(llmDotLog, minSizeForLlmLogCompressionKB, "job llm");
    }

    private static void compressFileIfNeeded(File logFile, long thresholdInKB, String logFileDescription) throws IOException {
        if (thresholdInKB <= 0L || !logFile.isFile()) {
            return;
        }
        if (logFile.length() > thresholdInKB * 1024L) {
            logger.debug((Object)("Compressing too large " + logFileDescription + " log file:" + String.valueOf(logFile)));
            DKUFileUtils.gzCompress((File)logFile);
        }
    }
}

