/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetCopier {
    @Autowired
    private FutureService futureService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.copy");

    public DatasetCopier() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public FutureResponse<WarningsContext> startCopy_NT(DSSAuthCtx authCtx, AnyLoc sourceLoc, AnyLoc targetLoc, boolean syncSchema, Output.WriteMode writeMode) throws Exception {
        if (syncSchema) {
            try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
                Dataset source = this.datasetAccessService.getMandatory(sourceLoc);
                Dataset target = this.datasetAccessService.getMandatory(targetLoc);
                Schema schema = (Schema)JSON.deepCopy((Object)source.getSchema());
                target.fixupSchemaPerDatasetConstraint(authCtx, schema);
                schema.userModified = true;
                target.setSchema(schema);
                this.datasetSaveService.save(targetLoc.getProjectKey(), targetLoc.getId(), target.serialize(), authCtx);
                rwt.commit("Saved dataset schema for '" + String.valueOf(targetLoc) + " (copy from " + String.valueOf(sourceLoc) + ")");
            }
        }
        CopyThread ct = new CopyThread(authCtx, sourceLoc, targetLoc, writeMode);
        return this.futureService.runFuture(ct, 0L, new TypeToken<FutureResponse<WarningsContext>>(){});
    }

    static class CopyThread
    extends SimpleFutureThread<WarningsContext> {
        private AnyLoc sourceLoc;
        private AnyLoc targetLoc;
        private Output.WriteMode writeMode;
        private FuturePayload futurePayload;

        public CopyThread(AuthCtx owner, AnyLoc sourceLoc, AnyLoc targetLoc, Output.WriteMode writeMode) {
            super(owner);
            this.sourceLoc = sourceLoc;
            this.targetLoc = targetLoc;
            this.writeMode = writeMode;
        }

        @Override
        protected WarningsContext compute() throws Exception {
            SerializedDataset target;
            SerializedDataset source;
            StreamColumnFactory cf = new StreamColumnFactory();
            StreamRowFactory rf = new StreamRowFactory();
            WarningsContext warningsContext = new WarningsContext();
            DatasetsDAO dao = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
            TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
            try (Transaction t = ts.beginRead();){
                source = (SerializedDataset)dao.getMandatory(this.sourceLoc);
                target = (SerializedDataset)dao.getMandatory(this.targetLoc);
            }
            logger.info((Object)("Starting dataset copy from " + String.valueOf(this.sourceLoc) + " to " + String.valueOf(this.targetLoc) + " mode = " + String.valueOf(this.writeMode)));
            try (DatasetHandler dh = DatasetHandlerFactory.build(this.owner, Dataset.fromSerialized(target));){
                logger.info((Object)("output handles clear: " + dh.outputHandlesClear()));
                if (this.writeMode == Output.WriteMode.OVERWRITE && !dh.outputHandlesClear()) {
                    dh.clearAllData();
                    this.writeMode = Output.WriteMode.APPEND;
                }
            }
            ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(this.owner, Dataset.fromSerialized(target), Partition.newNP(), (ColumnFactory)cf, warningsContext, this.writeMode);
            ProcessorOutput out = streamer.getAsOutput();
            StreamableDatasetSelection selection = StreamableDatasetSelection.full();
            UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher((AuthCtx)this.owner, Dataset.fromSerialized(source), out, (ColumnFactory)cf, (RowFactory)rf);
            pusher.setWarningsContext(warningsContext);
            pusher.setDatasetSelection(selection);
            pusher.push();
            out.lastRowEmitted();
            return warningsContext;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        static {
            JSON.registerAdapter(CopyThread.class, (Object)new JSON.Adapter<CopyThread>(){

                public CopyThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    AnyLoc sourceLoc = (AnyLoc)ctx.deserialize(jsonObj.get("sourceLoc"), AnyLoc.class);
                    AnyLoc targetLoc = (AnyLoc)ctx.deserialize(jsonObj.get("targetLoc"), AnyLoc.class);
                    Output.WriteMode writeMode = (Output.WriteMode)ctx.deserialize(jsonObj.get("writeMode"), Output.WriteMode.class);
                    CopyThread ft = new CopyThread(owner, sourceLoc, targetLoc, writeMode);
                    return ft;
                }

                public JsonElement serialize(CopyThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    ret.add("sourceLoc", ctx.serialize((Object)ft.sourceLoc));
                    ret.add("targetLoc", ctx.serialize((Object)ft.targetLoc));
                    ret.add("writeMode", ctx.serialize((Object)ft.writeMode));
                    return ret;
                }
            });
        }
    }
}

