/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.vendor.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;

public class SchemaImportExport {
    public static String schemaToCSV(Schema schema) {
        StringBuilder buffer = new StringBuilder();
        for (SchemaColumn column : schema.getColumns()) {
            String colName = column.getName();
            String colType = column.getType().getName();
            buffer.append(colName).append(",").append(colType).append('\n');
        }
        return buffer.toString();
    }

    public static Schema schemaFromCSV(InputStream stream) throws IOException {
        try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(stream), ',');){
            List lines = csvReader.readAll();
            Schema schema = new Schema();
            schema.userModified = true;
            for (String[] line : lines) {
                if (line.length < 2) continue;
                String name = line[0];
                String type = line[1];
                schema.addColumn(name, Type.forName((String)type));
            }
            Schema schema2 = schema;
            return schema2;
        }
    }
}

