/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.consistency;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.consistency.DatasetConsistencyChecker;
import com.dataiku.dip.datasets.consistency.FlowAwareDatasetConsistencyChecker;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.server.SpringUtils;
import java.io.IOException;

public class HiveCSVFormatChecker
implements FlowAwareDatasetConsistencyChecker {
    private FlowDataset flowDataset;

    public HiveCSVFormatChecker(FlowGraph graph, FlowDataset flowDataset) {
        this.flowDataset = flowDataset;
    }

    @Override
    public void cheapCheck(DatasetConsistencyChecker.DatasetConsistencyCheckResult result) throws IOException {
        boolean needsCheck = false;
        for (GraphNode graphNode : this.flowDataset.getSuccessors()) {
            SerializedRecipe recipe;
            if (!(graphNode instanceof FlowRecipe) || !"hive".equals((recipe = ((FlowRecipe)graphNode).getModel()).getType()) && !"impala".equals(recipe.getType())) continue;
            needsCheck = true;
        }
        if (needsCheck) {
            this.checkFormat(result);
        }
    }

    private void checkFormat(DatasetConsistencyChecker.DatasetConsistencyCheckResult result) throws IOException {
        DatasetsDAO dao = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        Dataset dataset = this.flowDataset.getMandatory(dao);
        if ("csv".equals(dataset.getFormatType())) {
            CSVFormatConfig config = dataset.getFormatParamsAs(CSVFormatConfig.class);
            if (config.arrayMapFormat != CSVFormatConfig.CSVComplexTypeSerialization.hive) {
                result.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_USED_FOR_HIVE_BAD_CSV_FORMAT, "arrayMapFormat should be set to Hive");
            }
            if (config.dateSerializationFormat != CSVFormatConfig.DateSerializationFormat.HIVE) {
                result.withWarning((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_USED_FOR_HIVE_BAD_CSV_FORMAT, "Date serialization format should be set to HIVE");
            }
        }
    }
}

