/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FileFormatDatasetTestHandler;
import com.dataiku.dip.datasets.fs.HTTPDatasetHandler;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.server.services.TransactionService;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class HTTPDatasetTestHandler
extends FileFormatDatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    private HTTPDatasetHandler handler;
    private static Logger logger = Logger.getLogger((String)"dku.input.http");

    public HTTPDatasetTestHandler(HTTPDatasetHandler handler, Dataset dataset) {
        super(dataset);
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        return new InfoMessage.InfoMessages();
    }

    @Override
    protected String suggestName() throws Exception {
        return DatasetInspector.slufigyAndUnicize(this.dataset.getProjectKey(), this.handler.suggestName(), this.dao, this.transactionService);
    }

    public StreamsInputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult result) throws Exception {
        HTTPDatasetHandler.InputSplit sampleSplit;
        if (!this.checkDatasetParams(this.handler.authCtx, this.dataset, result)) {
            return null;
        }
        try {
            sampleSplit = this.handler.getSampleSplit();
        }
        catch (IOException e) {
            logger.info((Object)"HTTP dataset test failed", (Throwable)e);
            result.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
        if (sampleSplit.isEmpty()) {
            result.empty = true;
        }
        result.connectionOK = true;
        return sampleSplit;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        FSLikeDatasetTestHandler.FSLikeDatasetTestResult result = this.testFormat(this.handler.authCtx, true, false);
        ret.empty = result.empty;
        if (result.format != null) {
            ret.result = result.format.schemaDetection;
        }
        return ret;
    }

    @Override
    protected HTTPDatasetHandler.InputSplit getSampleSplitForShapeFile() throws Exception {
        return this.handler.getSingleSplit();
    }
}

