/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.RecordContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PGCopySQLTableOutput
implements Output,
CanShareSQLConnection {
    private final AbstractSQLTableDatasetHandler handler;
    private final Dataset dataset;
    private final Partition targetPartition;
    private final Map<String, String> targetPartitionValues = Maps.newHashMap();
    private final SQLConnectionProvider.SQLConnectionData connData;
    private final PostgreSQLDialect.PostgreSQLDatasetConfig.WriteWithCopyBadDataBehavior writeWithCopyBadDataBehavior;
    private final WarningsContext warnContext;
    private CanShareSQLConnection.SQLConnectionShare connectionShare;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.output.sql.pglike");

    public PGCopySQLTableOutput(AbstractSQLTableDatasetHandler handler, Dataset outputDatast, Partition targetPartition, WarningsContext warnContext) throws Exception {
        this.handler = handler;
        assert (DatasetInspector.isSQL(outputDatast));
        if (outputDatast.getSchema() == null) {
            throw ErrorContext.iaef((String)"Cannot write to a SQLTable dataset with no schema: %s", (Object)outputDatast.getName(), (Object[])new Object[0]);
        }
        if (!DatasetInspector.isSQLTable(outputDatast)) {
            throw ErrorContext.iaef((String)"Cannot write to a SQL dataset in 'query' mode: %s", (Object)outputDatast.getName(), (Object[])new Object[0]);
        }
        this.dataset = outputDatast;
        this.targetPartition = targetPartition;
        this.connData = handler.getConnectionData();
        AbstractSQLDatasetHandler.AbstractSQLConfig config = this.dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        this.writeWithCopyBadDataBehavior = config instanceof PostgreSQLDialect.PostgreSQLDatasetConfig ? ((PostgreSQLDialect.PostgreSQLDatasetConfig)config).writeWithCopyBadDataBehavior : PostgreSQLDialect.PostgreSQLDatasetConfig.WriteWithCopyBadDataBehavior.NOVERIFY_ERROR;
        this.warnContext = warnContext;
        if (targetPartition != null && targetPartition.getDimensionValues().size() > 0) {
            Schema schema = this.dataset.getSchema();
            if (schema == null) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Empty dataset schema");
            }
            for (String dimensionName : this.dataset.getPartitioningSchema().getDimensionNames()) {
                DimensionValue dimensionValue = (DimensionValue)targetPartition.getDimensionValues().get(dimensionName);
                if (dimensionValue == null) {
                    this.targetPartitionValues.put(dimensionName, null);
                    continue;
                }
                SchemaColumn partitionColumn = this.dataset.getSchema().getColumn(dimensionName);
                if (partitionColumn == null) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset '" + this.dataset.getName() + "' does not contain the partitioning column: " + dimensionName);
                }
                Type partitionColumnType = partitionColumn.getType();
                this.targetPartitionValues.put(dimensionName, ExpressionUtils.getStringForDimensionValue(dimensionValue, partitionColumnType));
            }
        }
    }

    @Override
    public void shareSQLConnection(CanShareSQLConnection.SQLConnectionShare share) throws DKUSecurityException {
        this.connectionShare = share;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        CanShareSQLConnection.SQLConnectionShare connectionShareToUse = this.connectionShare == null ? new CanShareSQLConnection.SQLConnectionShare(this.handler.getConnectionData()) : this.connectionShare;
        return new PGCopySQLTableOutputWriter(mode, connectionShareToUse);
    }

    private class PGCopySQLTableOutputWriter
    extends OutputWriter {
        private Output.WriteMode writeMode;
        private SQLConnectionProvider.SQLConnectionWrapper conn;
        private PipedInputStream pis;
        private PipedOutputStream pos;
        private Writer wr;
        private volatile Exception writingThreadFailure;
        private Thread writingThread;
        private List<Column> columns = new ArrayList<Column>();
        private List<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
        private Map<Integer, String> partitioningColumnIndices = Maps.newHashMap();
        private RecordContext rc = new RecordContext();
        private StorageTypeVerifier storageTypeVerifier = new StorageTypeVerifier();
        private CanShareSQLConnection.SQLConnectionShare connectionShare;
        private ComputeResourceUsage cru;
        int totalRows = 0;
        int rowsWithFailedCells = 0;

        PGCopySQLTableOutputWriter(Output.WriteMode mode, CanShareSQLConnection.SQLConnectionShare connectionShare) {
            this.writeMode = mode;
            this.connectionShare = connectionShare;
        }

        private String createCopyStatement(SQLDialect dialect) {
            boolean isGreenplum5;
            boolean isYellowBrick = "Yellowbrick".equalsIgnoreCase(dialect.getId()) && PGCopySQLTableOutput.this.handler.getMeta() == BuiltinSQLDatasets.JDBC_META;
            boolean bl = isGreenplum5 = PGCopySQLTableOutput.this.handler.getMeta() == BuiltinSQLDatasets.GREENPLUM_META && StringUtils.isNotBlank((String)dialect.getId()) && dialect.getId().endsWith("5");
            if (PGCopySQLTableOutput.this.handler.getMeta() == BuiltinSQLDatasets.POSTGRESQL_META || PGCopySQLTableOutput.this.handler.getMeta() == BuiltinSQLDatasets.ALLOYDB_META || PGCopySQLTableOutput.this.handler.getMeta() == BuiltinSQLDatasets.DATABRICKS_LAKEBASE_META || isYellowBrick || isGreenplum5) {
                return "COPY " + dialect.getQuotedTableFullName(PGCopySQLTableOutput.this.handler.resolvedAbstractConfig.catalog, PGCopySQLTableOutput.this.handler.resolvedAbstractConfig.schema, PGCopySQLTableOutput.this.handler.resolvedAbstractConfig.table) + " FROM STDIN WITH CSV QUOTE '\"' ESCAPE '\\'";
            }
            return "COPY " + dialect.getQuotedTableFullName(PGCopySQLTableOutput.this.handler.resolvedAbstractConfig.catalog, PGCopySQLTableOutput.this.handler.resolvedAbstractConfig.schema, PGCopySQLTableOutput.this.handler.resolvedAbstractConfig.table) + " FROM STDIN WITH CSV QUOTE '\"' ESCAPE '\\\\'";
        }

        public void init(ColumnFactory cf) throws Exception {
            SQLConnectionProvider.SQLConnectionData cd = this.connectionShare.getConnectionData();
            this.conn = this.connectionShare.take(PGCopySQLTableOutput.this.handler.getAuthCtx(), PGCopySQLTableOutput.this.handler.getDataset().getProjectKey());
            SQLDialect dialect = cd.getDialect();
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            dialect.dropIfNeededAndCreateTableOrPartition(PGCopySQLTableOutput.this.handler.getAuthCtx(), cd, this.conn, PGCopySQLTableOutput.this.dataset, PGCopySQLTableOutput.this.targetPartition, this.writeMode, messages);
            if (!messages.isEmpty()) {
                PGCopySQLTableOutput.this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
            SQLUtils.executePreWriteStatements(cd, this.conn, PGCopySQLTableOutput.this.dataset);
            Connection sqlConn = this.conn.getConnectionUnsafe(true);
            final Object copyManager = sqlConn.getClass().getMethod("getCopyAPI", new Class[0]).invoke((Object)sqlConn, new Object[0]);
            final Method copyInMethod = copyManager.getClass().getMethod("copyIn", String.class, InputStream.class);
            this.pis = new PipedInputStream();
            this.pos = new PipedOutputStream(this.pis);
            this.wr = new BufferedWriter(new Tee(new OutputStreamWriter((OutputStream)this.pos, "utf8")));
            final String copySQL = this.createCopyStatement(dialect);
            this.cru = SQLComputeResourceUsage.startSQLQuery(this.conn, copySQL, true);
            this.writingThread = new Thread(){

                @Override
                public void run() {
                    try {
                        copyInMethod.invoke(copyManager, copySQL, PGCopySQLTableOutputWriter.this.pis);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Copy thread failed", (Throwable)e);
                        IOUtils.closeQuietly((InputStream)PGCopySQLTableOutputWriter.this.pis);
                        PGCopySQLTableOutputWriter.this.writingThreadFailure = e;
                    }
                }
            };
            this.writingThread.start();
            HashSet partitioningColumnNames = Sets.newHashSet();
            if (PGCopySQLTableOutput.this.dataset.getPartitioningSchema().isPartitioned()) {
                partitioningColumnNames.addAll(PGCopySQLTableOutput.this.dataset.getPartitioningSchema().getDimensionNames());
            }
            for (SchemaColumn sc : PGCopySQLTableOutput.this.dataset.getSchema().getColumns()) {
                if (partitioningColumnNames.contains(sc.getName())) {
                    this.partitioningColumnIndices.put(this.columns.size(), sc.getName());
                }
                this.columns.add(cf.column(sc.getName()));
                this.schemaColumns.add(sc);
            }
        }

        public void emitRow(Row row) throws Exception {
            if (this.writingThreadFailure != null) {
                logger.error((Object)"Background thread failed, aborting");
                throw this.writingThreadFailure;
            }
            this.cru.setUpdateCheckingIfMissing(SQLComputeResourceUsage.getUpdateChecking());
            try {
                this.rc.setLine((long)(this.totalRows + 1));
                for (int col = 0; col < this.columns.size(); ++col) {
                    if (col > 0) {
                        this.wr.write(44);
                    }
                    if (this.partitioningColumnIndices.containsKey(col)) {
                        CSVOutputFormatter.appendUNIXStyle(this.wr, PGCopySQLTableOutput.this.targetPartitionValues.get(this.partitioningColumnIndices.get(col)), ',', '\"', Character.valueOf('\\'));
                        continue;
                    }
                    Column column = this.columns.get(col);
                    String v = row.get(column);
                    if (PGCopySQLTableOutput.this.writeWithCopyBadDataBehavior == PostgreSQLDialect.PostgreSQLDatasetConfig.WriteWithCopyBadDataBehavior.DISCARD_CELL) {
                        boolean wasNull = StringUtils.isBlank((String)v);
                        if (StringUtils.isBlank((String)(v = this.storageTypeVerifier.verify(v, this.schemaColumns.get(col), StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING, PGCopySQLTableOutput.this.warnContext, this.rc, true))) && !wasNull) {
                            ++this.rowsWithFailedCells;
                        }
                    } else if (PGCopySQLTableOutput.this.writeWithCopyBadDataBehavior == PostgreSQLDialect.PostgreSQLDatasetConfig.WriteWithCopyBadDataBehavior.ERROR) {
                        v = this.storageTypeVerifier.verify(v, this.schemaColumns.get(col), StorageTypeVerifier.DataTypeMismatchBehavior.ERROR, PGCopySQLTableOutput.this.warnContext, this.rc, true);
                    }
                    v = StorageTypeVerifier.normalize(v, this.schemaColumns.get(col));
                    if (v == null || v.isEmpty()) {
                        CSVOutputFormatter.appendUNIXStyle(this.wr, "", ',', '\"', Character.valueOf('\\'));
                        continue;
                    }
                    CSVOutputFormatter.appendUNIXStyle(this.wr, v, ',', '\"', Character.valueOf('\\'));
                }
                this.wr.write(10);
                ++this.totalRows;
                if (this.totalRows % 10000 == 0) {
                    this.cru.updateInsertedRowCountAndCheck((long)this.totalRows);
                    logger.infoV("Written rows=%d rowsWithFailedCells=%d", new Object[]{this.totalRows, this.rowsWithFailedCells});
                }
            }
            catch (IOException e) {
                if (this.writingThreadFailure != null) {
                    logger.error((Object)"Background thread failed, aborting");
                    throw this.writingThreadFailure;
                }
                throw e;
            }
        }

        public void lastRowEmitted() throws Exception {
            this.cru.reportCompleteWithRowCount((long)this.totalRows);
            this.wr.close();
            this.pos.close();
            this.writingThread.join();
            if (this.writingThreadFailure != null) {
                logger.error((Object)"Copy failed", (Throwable)this.writingThreadFailure);
                SQLUtils.unsafeRollbackAndClose(this.conn);
                throw this.writingThreadFailure;
            }
            logger.info((Object)("Copy done, copied " + this.totalRows + " records"));
            SQLUtils.executePostWriteStatements(PGCopySQLTableOutput.this.connData, this.conn, PGCopySQLTableOutput.this.dataset);
            this.connectionShare.give(false);
            this.conn = null;
            logger.info((Object)("Transaction done, copied " + this.totalRows + " records"));
        }

        public void cancel() throws Exception {
            if (this.cru != null) {
                this.cru.reportCompleteNoFail();
            }
            logger.info((Object)"Aborting transaction");
            if (this.pos != null) {
                this.pos.close();
            }
            if (this.conn != null) {
                this.connectionShare.give(true);
                this.conn = null;
            }
        }

        public long writtenBytes() throws IOException {
            return 0L;
        }
    }

    public class Tee
    extends Writer {
        private Writer wr;

        public Tee(Writer wr) {
            this.wr = wr;
        }

        @Override
        public void close() throws IOException {
            this.wr.close();
        }

        @Override
        public void flush() throws IOException {
            this.wr.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.wr.write(cbuf, off, len);
        }
    }
}

