/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AutoFastPathConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLViaCloudAutoFastPathOutput;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import org.apache.commons.lang.StringUtils;

public class SQLViaCloudAutoFastPathBuilder {
    private static void checkCloudConnectionHasCleanPathForAutoFastPath(AbstractCloudStorageConnection conn) {
        if (conn instanceof EC2Connection) {
            if (StringUtils.isBlank((String)((EC2Connection)conn).params.chbucket)) {
                throw new IllegalArgumentException("Auto-fast-path requires a S3 connection with a bucket restriction. Invalid settings in connection " + conn.name);
            }
            return;
        }
        if (conn instanceof AzureConnection) {
            if (StringUtils.isBlank((String)((AzureConnection)conn).params.chcontainer)) {
                throw new IllegalArgumentException("Auto-fast-path requires an Azure connection with a container restriction. Invalid settings in connection " + conn.name);
            }
            return;
        }
        if (conn instanceof GCSConnection) {
            if (StringUtils.isBlank((String)((GCSConnection)conn).params.chbucket)) {
                throw new IllegalArgumentException("Auto-fast-path requires an GCS connection with a bucket restriction. Invalid settings in connection " + conn.name);
            }
            return;
        }
        if (conn instanceof DatabricksVolumeConnection) {
            if (StringUtils.isBlank((String)((DatabricksVolumeConnection)conn).params.chvolume)) {
                throw new IllegalArgumentException("Auto-fast-path requires an Databricks volume connection with a volume restriction. Invalid settings in connection " + conn.name);
            }
            return;
        }
        throw new IllegalArgumentException("Auto-fast-path requires a Cloud connection. Invalid settings in connection " + conn.name);
    }

    public SQLViaCloudAutoFastPathOutput buildIfCanUseAutoFastPath(AbstractSQLTableDatasetHandler handler, Partition targetPartition, WarningsContext warningsContext) throws Exception {
        AbstractSQLConnection connection = handler.getDSSConnection();
        if (!(connection instanceof AutoFastPathConnection)) {
            return null;
        }
        AutoFastPathConnection fastPathConnection = (AutoFastPathConnection)((Object)connection);
        if (!fastPathConnection.useAutoFastConnection()) {
            return null;
        }
        String fpConnection = fastPathConnection.getAutoFastPathConnection();
        DSSConnection dssConnection = ConnectionsDAO.get().getConnection(handler.getAuthCtx(), fpConnection);
        if (dssConnection instanceof DatabricksConnection) {
            dssConnection = ((DatabricksConnection)dssConnection).asDatabricksVolumeConnection();
        }
        if (!(dssConnection instanceof AbstractCloudStorageConnection)) {
            throw new IllegalArgumentException("Auto-fast-path connection " + fpConnection + " is not a cloud storage connection");
        }
        AbstractCloudStorageConnection cloudConnection = (AbstractCloudStorageConnection)dssConnection;
        if (!fastPathConnection.isSupportedCloudStorage(cloudConnection)) {
            throw new IllegalArgumentException("Auto-fast-path connection " + fpConnection + " is not a supported cloud storage connection");
        }
        SQLViaCloudAutoFastPathBuilder.checkCloudConnectionHasCleanPathForAutoFastPath(cloudConnection);
        return new SQLViaCloudAutoFastPathOutput(handler.getAuthCtx(), handler, handler.getDataset(), targetPartition, warningsContext, cloudConnection, fastPathConnection.getAutoFastPathConnectionPath());
    }
}

