/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.ArrayList;
import java.util.List;

@PolyJSON(value={@Mapping(type="document", value=Document.class), @Mapping(type="section", value=Section.class), @Mapping(type="text", value=Text.class), @Mapping(type="image", value=Image.class), @Mapping(type="table", value=Table.class)})
public abstract class StructuredContent {
    public List<Integer> pages;
    public List<StructuredContent> content;

    public abstract String getType();

    public void addChild(StructuredContent child) {
        if (this.content == null) {
            this.content = new ArrayList<StructuredContent>();
        }
        this.content.add(child);
    }

    public static class Table
    extends StructuredContent {
        public String text;
        public String description;

        @Override
        public String getType() {
            return "table";
        }
    }

    public static class Text
    extends StructuredContent {
        public String text;

        @Override
        public String getType() {
            return "text";
        }

        public Text() {
        }

        public Text(String text) {
            this.text = text;
        }
    }

    public static class Image
    extends StructuredContent {
        public String mimeType;
        public String description;
        public Integer resolution;
        public Long height;
        public Long width;

        @Override
        public String getType() {
            return "image";
        }
    }

    public static class Document
    extends Section {
        @Override
        public String getType() {
            return "document";
        }

        public Document() {
            this.level = 0;
        }
    }

    public static class Section
    extends StructuredContent {
        public Integer level;
        public String title;

        @Override
        public String getType() {
            return "section";
        }

        public Section() {
        }

        public Section(int level, String title) {
            this.level = level;
            this.title = title;
        }
    }
}

