/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.resolver;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.docgen.resolver.ResolvedResult;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.model.BaseExport;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.security.AuthCtx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ExportOutputExecutor {
    private final Map<BaseExport, SingleExportExecutor<? extends BaseExport>> exporters = new HashMap<BaseExport, SingleExportExecutor<? extends BaseExport>>();
    private final InfoMessage.InfoMessages messages;
    private final AuthCtx authCtx;
    private static final Logger logger = Logger.getLogger((String)"dku.docgen");

    public ExportOutputExecutor(AuthCtx authCtx, InfoMessage.InfoMessages messages) {
        this.authCtx = authCtx;
        this.messages = messages;
    }

    public ResolvedResult.Export registerAndGetResolvedResult(PlaceholderOutput.Export<? extends BaseExport> output, String name) {
        BaseExport export = output.getExport();
        ResolvedResult.Export res = output.toResolvedResult(name);
        this.exporters.computeIfAbsent(export, k -> new SingleExportExecutor(output)).addResolvedResult(res);
        return res;
    }

    public void executeExports() throws InterruptedException {
        FutureProgressState exportsProgress = FutureProgress.pushState((String)"Exporting images");
        exportsProgress.setTarget((long)this.exporters.size());
        for (SingleExportExecutor<? extends BaseExport> entry : this.exporters.values()) {
            try {
                ExportResult exportResult = entry.executeAndWait();
                entry.resolvedResults.forEach(result -> {
                    result.exportId = exportResult.exportId;
                });
            }
            catch (Exception e) {
                String affectedPlaceholderNames = entry.resolvedResults.stream().map(result -> result.name).collect(Collectors.joining(", "));
                InfoMessage errorMessage = InfoMessage.warning((String)"An unexpected error happened while exporting a placeholder", (String)("Affected placeholders: " + affectedPlaceholderNames));
                this.messages.addMessage(errorMessage);
                logger.warn((Object)(errorMessage.title + "\n" + errorMessage.details), (Throwable)e);
            }
            exportsProgress.increment(1.0);
        }
        FutureProgress.popState();
    }

    private class SingleExportExecutor<T extends BaseExport> {
        private final T export;
        private final BaseExportService<T, ?, ?> service;
        private final List<ResolvedResult.Export> resolvedResults = new ArrayList<ResolvedResult.Export>();

        public SingleExportExecutor(PlaceholderOutput.Export<T> output) {
            this.export = output.getExport();
            this.service = output.getExportService();
        }

        public void addResolvedResult(ResolvedResult.Export result) {
            this.resolvedResults.add(result);
        }

        public ExportResult executeAndWait() throws Exception {
            return this.service.exportAndWait(ExportOutputExecutor.this.authCtx, this.export);
        }
    }
}

