/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.engine.python;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.eda.EdaErrorCodes;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.python.EDAKernelComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.python.EDAKernelProtocol;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;

public class EDAKernelComputationResultSession
implements ComputationResultSession {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.python");
    private final SimplePythonKernel kernel;
    private final Lock lock;
    private final ComputationResult result;
    private final ComputationResultDataStreamer dataStreamer;
    private boolean isClosed;

    public EDAKernelComputationResultSession(SimplePythonKernel kernel, Lock lock, ComputationResult result) {
        this.kernel = kernel;
        this.lock = lock;
        this.result = result;
        this.dataStreamer = new EDAKernelComputationResultDataStreamer(kernel, lock);
        this.isClosed = false;
    }

    @Override
    public ComputationResult getComputationResult() {
        return this.result;
    }

    @Override
    public ComputationResultDataStreamer getDataStreamer() {
        return this.dataStreamer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        EDAKernelComputationResultSession eDAKernelComputationResultSession = this;
        synchronized (eDAKernelComputationResultSession) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.clearDataStreams();
    }

    private void clearDataStreams() throws Exception {
        List<ComputationResultDataStreamer.DataStreamId> sIds = this.result.getDataStreamIds();
        if (sIds.isEmpty()) {
            return;
        }
        if (!this.kernel.isAlive()) {
            logger.warnV("The EDA kernel is no longer alive: could not clear data streams (ids: %s)", new Object[]{sIds.stream().map(s -> s.value).collect(Collectors.joining(", "))});
            return;
        }
        this.lock.lockInterruptibly();
        try {
            this.kernel.getLink().sendRequest((Object)new EDAKernelProtocol.ClearDataStreamCommand(sIds));
            this.kernel.getLink().receiveJsonResponse(EDAKernelProtocol.DataStreamClearedResponse.class);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Could not clear data streams from the EDA kernel (ids: %s)", new Object[]{sIds.stream().map(s -> s.value).collect(Collectors.joining(", "))});
            this.kernel.close();
            throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "Could not clear data streams in the EDA kernel", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

