/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.TTest1Samp;
import com.dataiku.dip.eda.compute.computations.univariate.ZTest1Samp;
import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;
import javax.annotation.Nullable;

public class TZTest1SampCard
extends UnivariateCard
implements CardWithConfidenceLevel,
RecipeCompatibleCard {
    public static final String TYPE = "ttest_ztest_1samp";
    public double hypothesizedMean;
    @Nullable
    public Double knownStdDev;
    public double confidenceLevel;
    public AlternativeHypothesis alternative = AlternativeHypothesis.TWO_SIDED;

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                Computation.UnivariateComputation testComputation = TZTest1SampCard.this.knownStdDev == null ? new TTest1Samp(TZTest1SampCard.this.column.name, TZTest1SampCard.this.hypothesizedMean, TZTest1SampCard.this.alternative, TZTest1SampCard.this.confidenceLevel) : new ZTest1Samp(TZTest1SampCard.this.column.name, TZTest1SampCard.this.hypothesizedMean, TZTest1SampCard.this.knownStdDev, TZTest1SampCard.this.alternative, TZTest1SampCard.this.confidenceLevel);
                return new MultiComputation(testComputation, BoxPlotFragment.getComputationPlan(TZTest1SampCard.this.column.name));
            }

            @Override
            public CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                BoxPlotFragment boxPlot = BoxPlotFragment.build(result.get(1));
                if (TZTest1SampCard.this.knownStdDev == null) {
                    TTest1Samp.TTest1SampResult ttest = result.get(0).as(TTest1Samp.TTest1SampResult.class);
                    return new TZTest1SampCardResult(ttest.statistic, ttest.pvalue, ttest.mean, ttest.ciLower, ttest.ciUpper, ttest.dof, boxPlot);
                }
                ZTest1Samp.ZTest1SampResult ztest = result.get(0).as(ZTest1Samp.ZTest1SampResult.class);
                return new TZTest1SampCardResult(ztest.statistic, ztest.pvalue, ztest.mean, ztest.ciLower, ztest.ciUpper, null, boxPlot);
            }
        };
    }

    public TZTest1SampCard(Variable column, double hypothesizedMean, Double knownStdDev, AlternativeHypothesis alternative) {
        this.column = column;
        this.hypothesizedMean = hypothesizedMean;
        this.knownStdDev = knownStdDev;
        this.alternative = alternative;
    }

    private TZTest1SampCard() {
    }

    public static class TZTest1SampCardResult
    extends CardResult {
        public double statistic;
        public double pvalue;
        public double mean;
        @Nullable
        public Double ciLower;
        @Nullable
        public Double ciUpper;
        @Nullable
        public Integer dof;
        public BoxPlotFragment boxPlot;

        public TZTest1SampCardResult(double statistic, double pvalue, double mean, @Nullable Double ciLower, @Nullable Double ciUpper, @Nullable Integer dof, BoxPlotFragment boxPlot) {
            this.statistic = statistic;
            this.pvalue = pvalue;
            this.dof = dof;
            this.boxPlot = boxPlot;
            this.mean = mean;
            this.ciLower = ciLower;
            this.ciUpper = ciUpper;
        }

        private TZTest1SampCardResult() {
        }
    }
}

