/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.EdaErrorCodes;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.common.ResampledComputation;
import com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.AllFilter;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.MultiAnumGrouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.resampling.ResamplerSettings;
import com.dataiku.dip.eda.compute.resampling.ResamplerSpec;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.GroupedCompiledCardWrapper;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.CountCompleteFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.TimeInfoFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class TimeSeriesCard
extends Card {
    public Variable seriesColumn;
    public Variable timeColumn;
    public List<TimeSeriesIdentifier> seriesIdentifiers = Collections.emptyList();
    @Nullable
    public ResamplerSettings resamplerSettings = null;

    public TimeSeriesCard(Variable seriesColumn, Variable timeColumn) {
        this.seriesColumn = seriesColumn;
        this.timeColumn = timeColumn;
    }

    protected TimeSeriesCard() {
    }

    protected abstract TimeSeriesComputation getMainComputation();

    protected abstract TimeSeriesCardResult buildCardResult(AvailableResult var1, BoxPlotFragment var2, TimeInfoFragment var3);

    public static Grouping getSeriesIdGrouping(List<TimeSeriesIdentifier> seriesIdentifiers) {
        if (seriesIdentifiers.isEmpty()) {
            return SubsetGrouping.all();
        }
        List<String> columns = seriesIdentifiers.stream().map(it -> it.column.name).collect(Collectors.toList());
        return new MultiAnumGrouping(columns);
    }

    public static SubsetGrouping getSeriesIdValuesSubset(List<TimeSeriesIdentifier> seriesIdentifiers) {
        Filter seriesIdValuesFilter = seriesIdentifiers.stream().filter(it -> !it.values.isEmpty()).map(it -> new AnumFilter(it.column.name, new LinkedHashSet<String>(it.values))).map(Filter.class::cast).reduce(new AllFilter(), Filter::and);
        return new SubsetGrouping(seriesIdValuesFilter);
    }

    private ResamplerSpec getResamplerSpec() {
        List<String> columns = this.seriesIdentifiers.stream().map(it -> it.column.name).collect(Collectors.toList());
        return new ResamplerSpec(Collections.singletonList(this.seriesColumn.name), columns, this.timeColumn.name, this.resamplerSettings);
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        final boolean isLongFormatEnabled = this.seriesIdentifiers.size() > 0;
        final boolean hasResampling = this.resamplerSettings != null;
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                MultiComputation mainComputation = new MultiComputation(TimeSeriesCard.this.getMainComputation(), BoxPlotFragment.getComputationPlan(TimeSeriesCard.this.seriesColumn.name), TimeInfoFragment.getComputationPlan(TimeSeriesCard.this.timeColumn.name, !hasResampling));
                Computation internalComputation = this.groupBySeries(mainComputation);
                if (hasResampling) {
                    internalComputation = new MultiComputation(this.groupBySeries(CountCompleteFragment.getComputationPlan(TimeSeriesCard.this.seriesColumn.name)), new ResampledComputation(internalComputation, TimeSeriesCard.this.getResamplerSpec()));
                }
                return this.filterValuesSubset(internalComputation);
            }

            private GroupedComputation groupBySeries(Computation computation) {
                return new GroupedComputation(computation, TimeSeriesCard.getSeriesIdGrouping(TimeSeriesCard.this.seriesIdentifiers));
            }

            private GroupedComputation filterValuesSubset(Computation computation) {
                return new GroupedComputation(computation, TimeSeriesCard.getSeriesIdValuesSubset(TimeSeriesCard.this.seriesIdentifiers));
            }

            @Override
            protected CardResult buildFromAvailableResult(GroupedComputation.GroupedComputationResult result, ComputationResultDataStreamer dataStreamer) {
                String message;
                GroupedComputation.GroupedComputationResult bySeries;
                ComputationResult internalResult = result.results.get(0);
                if (!internalResult.isAvailable()) {
                    return 1.buildFromUnavailableResult(internalResult.asUnavailable());
                }
                List<ComputationResult> countCompleteResults = null;
                if (hasResampling) {
                    MultiComputation.MultiComputationResult mcr = internalResult.asMulti();
                    ComputationResult resampledUnchecked = mcr.get(1);
                    if (!resampledUnchecked.isAvailable()) {
                        return 1.buildFromUnavailableResult(resampledUnchecked.asUnavailable());
                    }
                    ComputationResult bySeriesUnchecked = resampledUnchecked.as(ResampledComputation.ResampledComputationResult.class).result;
                    if (!bySeriesUnchecked.isAvailable()) {
                        return 1.buildFromUnavailableResult(bySeriesUnchecked.asUnavailable());
                    }
                    bySeries = bySeriesUnchecked.asGrouped();
                    ComputationResult ccrUnchecked = mcr.get(0);
                    if (ccrUnchecked.isAvailable()) {
                        countCompleteResults = ccrUnchecked.asGrouped().results;
                    }
                } else {
                    bySeries = internalResult.asGrouped();
                }
                if (isLongFormatEnabled && bySeries.results.isEmpty()) {
                    message = "The intersect of the series identifiers is empty. Consider updating the series identifier configuration to allow more values.";
                    return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.FAILURE, message, EdaErrorCodes.ERR_EDA_COMPUTE_NO_DATA);
                }
                if (countCompleteResults != null && bySeries.results.size() != countCompleteResults.size()) {
                    message = "The groupings produced by the resampler and the backend are inconsistent.";
                    return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.FAILURE, message, EdaErrorCodes.ERR_EDA_COMPUTE_INVALID_RESULT);
                }
                ArrayList<CardResult> cardResults = new ArrayList<CardResult>();
                for (int i = 0; i < bySeries.results.size(); ++i) {
                    ComputationResult mcrUnchecked = bySeries.results.get(i);
                    if (!mcrUnchecked.isFullyAvailable()) {
                        cardResults.add(1.buildFromRecursivelyUnavailableResult(mcrUnchecked));
                        continue;
                    }
                    MultiComputation.MultiComputationResult mcr = mcrUnchecked.asMulti();
                    AvailableResult mainComputationResult = mcr.get(0).asAvailable();
                    BoxPlotFragment boxPlot = BoxPlotFragment.build(mcr.get(1));
                    TimeInfoFragment timeInfo = TimeInfoFragment.build(mcr.get(2));
                    TimeSeriesCardResult cardResult = TimeSeriesCard.this.buildCardResult(mainComputationResult, boxPlot, timeInfo);
                    cardResult.warnings = mcr.collectWarnings();
                    if (countCompleteResults != null) {
                        cardResult.beforeResamplingCount = CountCompleteFragment.buildResult(countCompleteResults.get(i));
                    }
                    cardResults.add(cardResult);
                }
                if (!isLongFormatEnabled && cardResults.size() == 1) {
                    return (CardResult)((Object)cardResults.get(0));
                }
                List<Filter> groupsAsFilters = bySeries.groups.listFilters();
                return new GroupedCompiledCardWrapper.GroupedCardResult(groupsAsFilters, cardResults);
            }
        };
    }

    @UIModel
    public static class TimeSeriesIdentifier {
        public Variable column;
        public List<String> values = Collections.emptyList();

        public TimeSeriesIdentifier(Variable column, List<String> values) {
            this.column = column;
            this.values = new ArrayList<String>(values);
        }

        public TimeSeriesIdentifier(Variable column, String value) {
            this(column, Collections.singletonList(value));
        }

        public TimeSeriesIdentifier(Variable column) {
            this(column, Collections.emptyList());
        }

        private TimeSeriesIdentifier() {
        }
    }

    public static abstract class TimeSeriesCardResult
    extends CardResult {
        public BoxPlotFragment boxPlot;
        public TimeInfoFragment timeInfo;
        @Nullable
        public Long beforeResamplingCount;

        public TimeSeriesCardResult(BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
            this.boxPlot = boxPlot;
            this.timeInfo = timeInfo;
        }

        protected TimeSeriesCardResult() {
        }
    }
}

