/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHeaderCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BivariateAnalysisSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() <= 3) {
            return Collections.emptyList();
        }
        SniffedVariable ySniffedVariable = this.findYSniffedVariable(sniffedVariables);
        Variable yVariable = Suggester.toVariable(ySniffedVariable);
        List xVariables = sniffedVariables.stream().filter(it -> !it.equals(ySniffedVariable)).map(Suggester::toVariable).collect(Collectors.toList());
        BivariateHeaderCard card = new BivariateHeaderCard();
        card.xColumns = xVariables;
        card.yColumn = yVariable;
        card.showHistogram = true;
        card.showMosaicPlot = true;
        card.showScatterPlot = true;
        SuggestCards.SuggestedCard suggestion = new SuggestCards.SuggestedCard("Bivariate analysis", card);
        return Collections.singletonList(suggestion);
    }

    private SniffedVariable findYSniffedVariable(List<SniffedVariable> sniffedVariables) {
        Optional<SniffedVariable> yCandidate = sniffedVariables.stream().filter(it -> it.entropy != null).max(Comparator.comparing(it -> it.entropy));
        if (yCandidate.isPresent()) {
            return yCandidate.get();
        }
        yCandidate = sniffedVariables.stream().filter(it -> it.cardinality > 1L).min(Comparator.comparing(it -> it.cardinality));
        return yCandidate.orElse(sniffedVariables.get(0));
    }
}

