/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.experimenttracking.mlflowfilter;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.antlrgrammars.MLflowFilterBaseVisitor;
import com.dataiku.dip.antlrgrammars.MLflowFilterLexer;
import com.dataiku.dip.antlrgrammars.MLflowFilterParser;
import com.dataiku.dip.experimenttracking.ExperimentTrackingInternalDBNoCreate;
import com.dataiku.dip.experimenttracking.ViewType;
import com.dataiku.dip.experimenttracking.mlflowfilter.MLflowFilterParsingException;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.lang.invoke.CallSite;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class MLflowSearchTranslator {
    public static final long MLFLOW_MAX_RESULTS = 100000L;
    protected final SQLDialect sqlDialect;
    protected ParserRuleContext parseTree;
    protected Pattern SEARCH_REGEXP;
    private final ExperimentTrackingInternalDBNoCreate mlflowInternalDBNoCreate;
    private final String projectKey;
    private final long limit;
    private final ViewType viewType;
    private final List<String> orderExpressions;
    private static final String METRICS_ALIAS_BASE = "m";
    private static final String PARAMS_ALIAS_BASE = "p";
    private static final String TAGS_ALIAS_BASE = "t";
    private static final String SORT_ALIAS_BASE = "o";

    public MLflowSearchTranslator(ExperimentTrackingInternalDBNoCreate experimentTrackingInternalDBNoCreate, String projectKey, List<String> orderExpressions, long limit, ViewType viewType) {
        this.mlflowInternalDBNoCreate = experimentTrackingInternalDBNoCreate;
        this.sqlDialect = this.mlflowInternalDBNoCreate.getDialect();
        this.projectKey = projectKey;
        this.orderExpressions = orderExpressions;
        this.limit = limit;
        this.viewType = viewType;
        if (limit > 100000L) {
            throw new IllegalArgumentException("Requested limit " + limit + " > 100000");
        }
    }

    protected abstract String getAliasLabel();

    protected abstract String getTableLabel();

    protected abstract String getTagTableLabel();

    protected abstract String getIdFieldLabel();

    protected abstract String getProjectKeyLabel();

    protected abstract String getLifeCycleStageFieldLabel();

    protected abstract String getTagIdFieldLabel();

    protected abstract String getDefaultOrderingLabel();

    protected abstract DKULogger getLogger();

    protected MLflowFilterParser initializeParser(String filterExpression) {
        this.getLogger().trace((Object)("Initialize MLflow filtering expression parser for `" + filterExpression + "'"));
        MLflowFilterLexer lexer = new MLflowFilterLexer((CharStream)CharStreams.fromString((String)(filterExpression != null ? filterExpression : "")));
        MLflowFilterParser parser = new MLflowFilterParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                ParsingError parsingError;
                IntervalSet expectedTokens = ((MLflowFilterParser)recognizer).getExpectedTokens();
                if (((CommonToken)offendingSymbol).getType() == -1) {
                    TreeSet<String> expectedTokensNames = new TreeSet<String>();
                    for (Integer expectedToken : expectedTokens.toSet()) {
                        expectedTokensNames.add(recognizer.getVocabulary().getDisplayName(expectedToken.intValue()));
                    }
                    parsingError = new ParsingError("Unexpected end of expression, expected : ", expectedTokensNames);
                } else {
                    String message = String.format("Did not recognize expression \"%s\" at %d:%d", ((CommonToken)offendingSymbol).getText(), line, charPositionInLine);
                    parsingError = new ParsingError(message);
                }
                MLflowSearchTranslator.this.getLogger().warnV("MLflow filter parsing error : %s at %d:%d, original message:%s", new Object[]{parsingError.message, line, charPositionInLine, msg});
                throw new MLflowFilterParsingException(parsingError);
            }
        };
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        return parser;
    }

    protected String additionalFilters() {
        return "";
    }

    public String translate() {
        MLflowEvaluationVisitor visitor = new MLflowEvaluationVisitor(this.mlflowInternalDBNoCreate);
        this.getLogger().trace((Object)"Visiting resulting AST...");
        String condition = (String)visitor.visit((ParseTree)this.parseTree);
        List<OrderingInfo> orderingInfos = this.processOrder(visitor);
        Object select = this.prepareSelectFrom(visitor, orderingInfos);
        select = (String)select + " WHERE " + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getProjectKeyLabel()) + "=" + this.sqlDialect.quoteString(this.projectKey);
        select = (String)select + this.filterLifecycleStage();
        select = (String)select + this.additionalFilters();
        select = (String)select + this.conditionsJoins(visitor);
        select = (String)select + this.applyJoinConditions(visitor);
        select = (String)select + this.orderingJoins(orderingInfos);
        if (StringUtils.isNotEmpty((String)condition)) {
            select = (String)select + " and (" + condition + ") ";
        }
        select = (String)select + this.applyOrdering(orderingInfos);
        if (this.limit > 0L) {
            select = (String)select + " LIMIT " + this.limit;
        }
        this.getLogger().trace((Object)("MLflow search request translated to `" + (String)select + "'"));
        return select;
    }

    private List<OrderingInfo> processOrder(MLflowEvaluationVisitor visitor) {
        this.getLogger().trace((Object)"Process order by...");
        ArrayList<OrderingInfo> ret = new ArrayList<OrderingInfo>();
        List<Object> nonBlankOrderExpressions = CollectionUtils.isNotEmpty(this.orderExpressions) ? this.orderExpressions.stream().filter(oe -> !StringUtils.isEmpty((String)oe)).collect(Collectors.toList()) : new ArrayList();
        if (CollectionUtils.isNotEmpty(nonBlankOrderExpressions)) {
            long curAlias = 0L;
            for (String string : nonBlankOrderExpressions) {
                this.getLogger().trace((Object)("Processing " + string));
                Matcher matcher = this.SEARCH_REGEXP.matcher(string);
                if (!matcher.matches()) {
                    throw new InvalidParameterException("Error analysing sort order `" + string + "'");
                }
                String type = matcher.group(1);
                String name = matcher.group(2);
                boolean asc = matcher.groupCount() < 3 || StringUtils.equalsIgnoreCase((String)matcher.group(3), (String)"asc");
                String qualifiedName = type + "." + name;
                if (!visitor.queryParamsMap.containsKey(qualifiedName)) {
                    String valueColumn;
                    String nameColumn = null;
                    String projectKeyQuotedColumn = null;
                    String idQuotedColumn = null;
                    String alias = null;
                    String table = null;
                    switch (type) {
                        case "metrics": {
                            table = this.mlflowInternalDBNoCreate.getQuotedFullResolvedTableName("METRICS");
                            alias = SORT_ALIAS_BASE + curAlias++;
                            nameColumn = alias + "." + this.sqlDialect.quoteIdentifier("METRIC_KEY");
                            valueColumn = alias + "." + this.sqlDialect.quoteIdentifier("METRIC_VALUE");
                            projectKeyQuotedColumn = alias + "." + this.sqlDialect.quoteIdentifier("METRIC_PROJECT_KEY");
                            idQuotedColumn = alias + "." + this.sqlDialect.quoteIdentifier("METRIC_RUN_ID");
                            break;
                        }
                        case "attributes": {
                            valueColumn = this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(name);
                            break;
                        }
                        case "tags": {
                            table = this.mlflowInternalDBNoCreate.getQuotedFullResolvedTableName(this.getTagTableLabel());
                            alias = SORT_ALIAS_BASE + curAlias++;
                            nameColumn = alias + "." + this.sqlDialect.quoteIdentifier("TAG_KEY");
                            valueColumn = alias + "." + this.sqlDialect.quoteIdentifier("TAG_VALUE");
                            projectKeyQuotedColumn = alias + "." + this.sqlDialect.quoteIdentifier("TAG_PROJECT_KEY");
                            idQuotedColumn = alias + "." + this.sqlDialect.quoteIdentifier(this.getTagIdFieldLabel());
                            break;
                        }
                        case "params": {
                            table = this.mlflowInternalDBNoCreate.getQuotedFullResolvedTableName("PARAMETERS");
                            alias = SORT_ALIAS_BASE + curAlias++;
                            nameColumn = alias + "." + this.sqlDialect.quoteIdentifier("PARAM_KEY");
                            valueColumn = alias + "." + this.sqlDialect.quoteIdentifier("PARAM_VALUE");
                            projectKeyQuotedColumn = alias + "." + this.sqlDialect.quoteIdentifier("PARAM_PROJECT_KEY");
                            idQuotedColumn = alias + "." + this.sqlDialect.quoteIdentifier("PARAM_RUN_ID");
                            break;
                        }
                        default: {
                            throw new Error("Unreachable");
                        }
                    }
                    ret.add(new OrderingInfo(table, alias, projectKeyQuotedColumn, idQuotedColumn, nameColumn, name, valueColumn, asc));
                    continue;
                }
                MLflowEvaluationVisitor.ParamInfo paramInfo = visitor.queryParamsMap.get(qualifiedName);
                ret.add(new OrderingInfo(null, null, null, null, paramInfo.nameColumn, name, paramInfo.valueColumn, asc));
            }
        } else {
            this.getLogger().trace((Object)"Using default sort order");
            ret.add(new OrderingInfo(null, null, null, null, null, null, this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getDefaultOrderingLabel()), false));
            ret.add(new OrderingInfo(null, null, null, null, null, null, this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getIdFieldLabel()), true));
        }
        return ret;
    }

    private String applyJoinConditions(MLflowEvaluationVisitor visitor) {
        this.getLogger().trace((Object)"Compute join conditions...");
        Object ret = "";
        if (!visitor.queryParamsMap.isEmpty()) {
            for (MLflowEvaluationVisitor.ParamInfo paramInfo : visitor.queryParamsMap.values()) {
                if (null == paramInfo.nameColumn) continue;
                ret = (String)ret + " and " + paramInfo.nameColumn + " = " + paramInfo.name;
            }
        }
        this.getLogger().trace((Object)("..." + (String)ret));
        return ret;
    }

    private String applyOrdering(List<OrderingInfo> orderingInfos) {
        this.getLogger().trace((Object)"Compute order by clause...");
        Object ret = "";
        if (CollectionUtils.isNotEmpty(orderingInfos)) {
            ret = (String)ret + " order by ";
            ArrayList<CallSite> orderClauses = new ArrayList<CallSite>();
            for (OrderingInfo cur : orderingInfos) {
                orderClauses.add((CallSite)((Object)(cur.valueColumn + " " + (cur.asc ? "ASC" : "DESC"))));
            }
            ret = (String)ret + StringUtils.join(orderClauses, (String)", ");
        }
        this.getLogger().trace((Object)("..." + (String)ret));
        return ret;
    }

    private String orderingJoins(List<OrderingInfo> orderingInfos) {
        this.getLogger().trace((Object)"Adding joins for ordering...");
        Object ret = "";
        for (OrderingInfo cur : orderingInfos) {
            if (StringUtils.isEmpty((String)cur.nameColumn)) continue;
            ret = (String)ret + " and " + cur.nameColumn + "=" + this.sqlDialect.quoteString(cur.name);
        }
        for (OrderingInfo cur : orderingInfos) {
            if (StringUtils.isEmpty((String)cur.idQuotedColumn)) continue;
            ret = (String)ret + " and " + cur.idQuotedColumn + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getIdFieldLabel()) + " and " + cur.projectKeyQuotedColumn + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getProjectKeyLabel());
        }
        this.getLogger().trace((Object)("... " + (String)ret));
        return ret;
    }

    private String conditionsJoins(MLflowEvaluationVisitor visitor) {
        long cur;
        this.getLogger().trace((Object)"Adding joins for conditions...");
        Object ret = "";
        for (cur = 0L; cur < visitor.filterOnMetrics; ++cur) {
            ret = (String)ret + " and m" + cur + "." + this.sqlDialect.quoteIdentifier("METRIC_RUN_ID") + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier("RUN_ID") + " and m" + cur + "." + this.sqlDialect.quoteIdentifier("METRIC_PROJECT_KEY") + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier("RUN_PROJECT_KEY");
        }
        for (cur = 0L; cur < visitor.filterOnParams; ++cur) {
            ret = (String)ret + " and p" + cur + "." + this.sqlDialect.quoteIdentifier("PARAM_RUN_ID") + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier("RUN_ID") + " and p" + cur + "." + this.sqlDialect.quoteIdentifier("PARAM_PROJECT_KEY") + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier("RUN_PROJECT_KEY");
        }
        for (cur = 0L; cur < visitor.filterOnTags; ++cur) {
            ret = (String)ret + " and t" + cur + "." + this.sqlDialect.quoteIdentifier(this.getTagIdFieldLabel()) + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getIdFieldLabel()) + " and t" + cur + "." + this.sqlDialect.quoteIdentifier("TAG_PROJECT_KEY") + "=" + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getProjectKeyLabel());
        }
        this.getLogger().trace((Object)("... " + (String)ret));
        return ret;
    }

    private String filterLifecycleStage() {
        Object ret = "";
        if (this.viewType == ViewType.ACTIVE_ONLY) {
            ret = (String)ret + " and " + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getLifeCycleStageFieldLabel()) + "=" + this.sqlDialect.quoteString("active");
        } else if (this.viewType == ViewType.DELETED_ONLY) {
            ret = (String)ret + " and " + this.getAliasLabel() + "." + this.sqlDialect.quoteIdentifier(this.getLifeCycleStageFieldLabel()) + "=" + this.sqlDialect.quoteString("deleted");
        } else if (this.viewType != ViewType.ALL) {
            throw new IllegalArgumentException("Invalid lifecycle stage `" + String.valueOf((Object)this.viewType) + "'");
        }
        return ret;
    }

    private String prepareSelectFrom(MLflowEvaluationVisitor visitor, List<OrderingInfo> orderingInfos) {
        long cur;
        this.getLogger().trace((Object)"Prepare 'select ... from ...' query part...");
        String select = "SELECT " + this.getAliasLabel() + ".* FROM " + this.mlflowInternalDBNoCreate.getQuotedFullResolvedTableName(this.getTableLabel()) + " " + this.getAliasLabel() + " ";
        for (cur = 0L; cur < visitor.filterOnMetrics; ++cur) {
            select = select + ", " + this.mlflowInternalDBNoCreate.getQuotedFullResolvedTableName("METRICS") + " m" + cur;
        }
        for (cur = 0L; cur < visitor.filterOnParams; ++cur) {
            select = select + ", " + this.mlflowInternalDBNoCreate.getQuotedFullResolvedTableName("PARAMETERS") + " p" + cur;
        }
        for (cur = 0L; cur < visitor.filterOnTags; ++cur) {
            select = select + ", " + this.mlflowInternalDBNoCreate.getQuotedFullResolvedTableName(this.getTagTableLabel()) + " t" + cur;
        }
        for (OrderingInfo cur2 : orderingInfos) {
            if (StringUtils.isEmpty((String)cur2.table)) continue;
            select = select + ", " + cur2.table + " " + cur2.alias;
        }
        this.getLogger().trace((Object)("... " + select));
        return select;
    }

    public static class MLflowEvaluationVisitor
    extends MLflowFilterBaseVisitor<Object> {
        public final ExperimentTrackingInternalDBNoCreate experimentTrackingInternalDBNoCreate;
        public final SQLDialect sqlDialect;
        public long filterOnMetrics = 0L;
        public long filterOnParams = 0L;
        public long filterOnTags = 0L;
        public Map<String, ParamInfo> queryParamsMap = new HashMap<String, ParamInfo>();

        MLflowEvaluationVisitor(ExperimentTrackingInternalDBNoCreate mlflowInternalDBNoCreate) {
            this.experimentTrackingInternalDBNoCreate = mlflowInternalDBNoCreate;
            this.sqlDialect = mlflowInternalDBNoCreate.getDialect();
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            return (null == aggregate ? "" : (String)aggregate) + (null == nextResult ? "" : (String)nextResult);
        }

        private String stripEscaping(String param) {
            return param.replaceFirst("^\"", "").replaceFirst("^`", "").replaceFirst("^'", "").replaceFirst("\"$", "").replaceFirst("`$", "").replaceFirst("'$", "").replace("\\\"", "\"");
        }

        private String applyOperator(String op, String value, String valueColumn, boolean colFirst) {
            if (colFirst) {
                return valueColumn + " " + op + " " + value;
            }
            return value + " " + op + " " + valueColumn;
        }

        @Override
        public Object visitParamComparison(MLflowFilterParser.ParamComparisonContext ctx) {
            return this.handleParamComparison(ctx.left.getText(), ctx.op.getText(), ctx.right.getText(), true);
        }

        @Override
        public Object visitRevParamComparison(MLflowFilterParser.RevParamComparisonContext ctx) {
            return this.handleParamComparison(ctx.right.getText(), ctx.op.getText(), ctx.left.getText(), false);
        }

        private Object handleParamComparison(String paramName, String op, String value, boolean colFirst) {
            paramName = paramName.replaceFirst("^params.", "");
            paramName = this.stripEscaping(paramName);
            value = this.stripEscaping(value);
            String paramsMapKey = "params." + paramName;
            Object tableAlias = !this.queryParamsMap.containsKey(paramsMapKey) ? MLflowSearchTranslator.PARAMS_ALIAS_BASE + this.filterOnParams : this.queryParamsMap.get((Object)paramsMapKey).tableAlias;
            String valueColumn = (String)tableAlias + "." + this.sqlDialect.quoteIdentifier("PARAM_VALUE");
            String nameColumn = (String)tableAlias + "." + this.sqlDialect.quoteIdentifier("PARAM_KEY");
            String name = this.sqlDialect.quoteString(paramName);
            String ret = this.applyOperator(op, this.sqlDialect.quoteString(value), valueColumn, colFirst);
            if (!this.queryParamsMap.containsKey(paramsMapKey)) {
                this.queryParamsMap.put(paramsMapKey, new ParamInfo((String)tableAlias, nameColumn, name, valueColumn, value));
                ++this.filterOnParams;
            }
            return ret;
        }

        @Override
        public Object visitTagComparison(MLflowFilterParser.TagComparisonContext ctx) {
            String tagName = ctx.left.getText();
            String op = ctx.op.getText();
            String value = ctx.right.getText();
            return this.handleTagComparison(tagName, op, value, true);
        }

        @Override
        public Object visitRevTagComparison(MLflowFilterParser.RevTagComparisonContext ctx) {
            String tagName = ctx.right.getText();
            String op = ctx.op.getText();
            String value = ctx.left.getText();
            return this.handleTagComparison(tagName, op, value, false);
        }

        private String handleTagComparison(String tagName, String op, String value, boolean colFirst) {
            tagName = tagName.replaceFirst("^tags.", "");
            tagName = this.stripEscaping(tagName);
            value = this.stripEscaping(value);
            String paramsMapKey = "tags." + tagName;
            Object tableAlias = !this.queryParamsMap.containsKey(paramsMapKey) ? MLflowSearchTranslator.TAGS_ALIAS_BASE + this.filterOnTags : this.queryParamsMap.get((Object)paramsMapKey).tableAlias;
            String valueColumn = (String)tableAlias + "." + this.sqlDialect.quoteIdentifier("TAG_VALUE");
            String nameColumn = (String)tableAlias + "." + this.sqlDialect.quoteIdentifier("TAG_KEY");
            String name = this.sqlDialect.quoteString(tagName);
            if (!this.queryParamsMap.containsKey(paramsMapKey)) {
                this.queryParamsMap.put(paramsMapKey, new ParamInfo((String)tableAlias, nameColumn, name, valueColumn, value));
                ++this.filterOnTags;
            }
            return this.applyOperator(op, this.sqlDialect.quoteString(value), valueColumn, colFirst);
        }

        @Override
        public Object visitRunAttributeComparison(MLflowFilterParser.RunAttributeComparisonContext ctx) {
            String attributeName = ctx.left.getText();
            String op = ctx.op.getText();
            String value = ctx.right.getText();
            return this.handleRunAttributeComparison(attributeName, op, value, true);
        }

        @Override
        public Object visitRevRunAttributeComparison(MLflowFilterParser.RevRunAttributeComparisonContext ctx) {
            String attributeName = ctx.right.getText();
            String op = ctx.op.getText();
            String value = ctx.left.getText();
            return this.handleRunAttributeComparison(attributeName, op, value, false);
        }

        private String handleRunAttributeComparison(String attributeName, String op, String value, boolean colFirst) {
            attributeName = attributeName.replaceFirst("^attributes.", "");
            attributeName = attributeName.replaceFirst("^attribute.", "");
            switch (attributeName = this.stripEscaping(attributeName)) {
                case "user_id": {
                    attributeName = "RUN_USER_ID";
                    break;
                }
                case "start_time": 
                case "created": 
                case "Created": {
                    attributeName = "RUN_START_TIME";
                    break;
                }
                case "end_time": {
                    attributeName = "RUN_END_TIME";
                    break;
                }
                case "run_id": {
                    attributeName = "RUN_ID";
                    break;
                }
                case "run_name": 
                case "Run name": 
                case "Run Name": 
                case "run name": {
                    return this.handleTagComparison("mlflow.runName", op, value, colFirst);
                }
                case "artifact_uri": {
                    attributeName = "RUN_ARTIFACT_URI";
                    break;
                }
                case "status": {
                    attributeName = "RUN_STATUS";
                    break;
                }
                default: {
                    ParsingError parsingError = new ParsingError("Attribute name `" + attributeName + "' is not valid. Valid names are `user_id', `start_time', `created', `Created', `end_time', `run_id', `run_name', `Run name', `Run Name', `run name', `artifact_uri' and `status'");
                    throw new MLflowFilterParsingException(parsingError);
                }
            }
            if (!StringUtils.containsAny((String)value, (String)"'\"`")) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException nfe) {
                    ParsingError parsingError = new ParsingError("Value `" + value + "' is not a valid number");
                    throw new MLflowFilterParsingException(parsingError);
                }
            }
            value = this.stripEscaping(value);
            String valueColumn = "r." + this.sqlDialect.quoteIdentifier(attributeName);
            this.queryParamsMap.put("attributes." + attributeName, new ParamInfo("r", null, null, valueColumn, value));
            return this.applyOperator(op, this.sqlDialect.quoteString(value), valueColumn, colFirst);
        }

        @Override
        public Object visitMetricComparison(MLflowFilterParser.MetricComparisonContext ctx) {
            String metricName = ctx.left.getText();
            String op = ctx.op.getText();
            String value = ctx.right.getText();
            return this.handleMetricComparison(metricName, op, value, true);
        }

        @Override
        public Object visitRevMetricComparison(MLflowFilterParser.RevMetricComparisonContext ctx) {
            String metricName = ctx.right.getText();
            String op = ctx.op.getText();
            String value = ctx.left.getText();
            return this.handleMetricComparison(metricName, op, value, false);
        }

        private String handleMetricComparison(String metricName, String op, String value, boolean colFirst) {
            metricName = metricName.replaceFirst("^metrics.", "");
            metricName = this.stripEscaping(metricName);
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                ParsingError parsingError = new ParsingError("Value `" + value + "' is not a valid number");
                throw new MLflowFilterParsingException(parsingError);
            }
            String paramsMapKey = "metrics." + metricName;
            Object tableAlias = !this.queryParamsMap.containsKey(paramsMapKey) ? MLflowSearchTranslator.METRICS_ALIAS_BASE + this.filterOnMetrics : this.queryParamsMap.get((Object)paramsMapKey).tableAlias;
            String valueColumn = (String)tableAlias + "." + this.sqlDialect.quoteIdentifier("METRIC_VALUE");
            String nameColumn = (String)tableAlias + "." + this.sqlDialect.quoteIdentifier("METRIC_KEY");
            String name = this.sqlDialect.quoteString(metricName);
            if (!this.queryParamsMap.containsKey(paramsMapKey)) {
                this.queryParamsMap.put(paramsMapKey, new ParamInfo((String)tableAlias, nameColumn, name, valueColumn, value));
                ++this.filterOnMetrics;
            }
            return this.applyOperator(op, value, valueColumn, colFirst);
        }

        @Override
        public Object visitAndExpression(MLflowFilterParser.AndExpressionContext ctx) {
            String left = (String)super.visit((ParseTree)ctx.left);
            String right = (String)super.visit((ParseTree)ctx.right);
            return "(" + left + ") AND (" + right + ")";
        }

        @Override
        public Object visitOrExpression(MLflowFilterParser.OrExpressionContext ctx) {
            String left = (String)super.visit((ParseTree)ctx.left);
            String right = (String)super.visit((ParseTree)ctx.right);
            return "(" + left + ") OR (" + right + ")";
        }

        @Override
        public Object visitNotExpression(MLflowFilterParser.NotExpressionContext ctx) {
            return "NOT (" + String.valueOf(super.visit((ParseTree)ctx.expr)) + ")";
        }

        @Override
        public Object visitAndExperimentExpression(MLflowFilterParser.AndExperimentExpressionContext ctx) {
            String left = (String)super.visit((ParseTree)ctx.left);
            String right = (String)super.visit((ParseTree)ctx.right);
            return "(" + left + ") AND (" + right + ")";
        }

        @Override
        public Object visitOrExperimentExpression(MLflowFilterParser.OrExperimentExpressionContext ctx) {
            String left = (String)super.visit((ParseTree)ctx.left);
            String right = (String)super.visit((ParseTree)ctx.right);
            return "(" + left + ") OR (" + right + ")";
        }

        @Override
        public Object visitNotExperimentExpression(MLflowFilterParser.NotExperimentExpressionContext ctx) {
            return "NOT (" + String.valueOf(super.visit((ParseTree)ctx.expr)) + ")";
        }

        @Override
        public Object visitExperimentAttributeComparison(MLflowFilterParser.ExperimentAttributeComparisonContext ctx) {
            String attributeName = ctx.left.getText();
            String op = ctx.op.getText();
            String value = ctx.right.getText();
            return this.handleExperimentAttributeComparison(attributeName, op, value, true);
        }

        @Override
        public Object visitRevExperimentAttributeComparison(MLflowFilterParser.RevExperimentAttributeComparisonContext ctx) {
            String attributeName = ctx.right.getText();
            String op = ctx.op.getText();
            String value = ctx.left.getText();
            return this.handleExperimentAttributeComparison(attributeName, op, value, false);
        }

        private String handleExperimentAttributeComparison(String attributeName, String op, String value, boolean colFirst) {
            attributeName = attributeName.replaceFirst("^attributes.", "");
            attributeName = attributeName.replaceFirst("^attribute.", "");
            switch (attributeName = this.stripEscaping(attributeName)) {
                case "name": {
                    attributeName = "EXP_NAME";
                    break;
                }
                case "creation_time": {
                    attributeName = "EXP_CREATION";
                    break;
                }
                case "last_update_time": {
                    attributeName = "EXP_LAST_UPDATE";
                    break;
                }
                default: {
                    ParsingError parsingError = new ParsingError("Attribute name `" + attributeName + "' is not valid. Valid names are `name', `creation_time' and `last_update_time'");
                    throw new MLflowFilterParsingException(parsingError);
                }
            }
            if (!StringUtils.containsAny((String)value, (String)"'\"`")) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException nfe) {
                    ParsingError parsingError = new ParsingError("Value `" + value + "' is not a valid number");
                    throw new MLflowFilterParsingException(parsingError);
                }
            }
            value = this.stripEscaping(value);
            String valueColumn = "e." + this.sqlDialect.quoteIdentifier(attributeName);
            this.queryParamsMap.put("attributes." + attributeName, new ParamInfo("e", null, null, valueColumn, value));
            return this.applyOperator(op, this.sqlDialect.quoteString(value), valueColumn, colFirst);
        }

        public static class ParamInfo {
            public final String tableAlias;
            public final String nameColumn;
            public final String name;
            public final String valueColumn;
            public final String value;

            public ParamInfo(String tableAlias, String nameColumn, String name, String valueColumn, String value) {
                this.tableAlias = tableAlias;
                this.nameColumn = nameColumn;
                this.name = name;
                this.valueColumn = valueColumn;
                this.value = value;
            }
        }
    }

    public static class OrderingInfo {
        public final String table;
        public final String alias;
        public final String projectKeyQuotedColumn;
        public final String idQuotedColumn;
        public final String nameColumn;
        public final String name;
        public final String valueColumn;
        public final boolean asc;

        public OrderingInfo(String table, String alias, String projectKeyQuotedColumn, String idQuotedColumn, String nameColumn, String name, String valueColumn, boolean asc) {
            this.table = table;
            this.alias = alias;
            this.projectKeyQuotedColumn = projectKeyQuotedColumn;
            this.idQuotedColumn = idQuotedColumn;
            this.nameColumn = nameColumn;
            this.name = name;
            this.valueColumn = valueColumn;
            this.asc = asc;
        }
    }

    public static class ParsingError {
        public String message;
        public Set<String> expectedTokens;
        public SerializedError error;

        public ParsingError(String message, Set<String> expectedTokens) {
            this.message = message;
            this.expectedTokens = expectedTokens;
        }

        public ParsingError(String message) {
            this.message = message;
        }
    }
}

