/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml;

import com.dataiku.dip.externalinfras.ExternalInfrasInputValidator;
import com.dataiku.dip.utils.ErrorContext;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AzureMLInputValidator
extends ExternalInfrasInputValidator {
    private static final Pattern AZURE_ML_SUBSCRIPTION_ID_PATTERN = Pattern.compile("^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$");
    private static final Pattern AZURE_ML_WORKSPACE_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_-]{2,32}$");
    private static final Pattern AZURE_ML_RESOURCE_GROUP_PATTERN = Pattern.compile("^([\\w().-]{1,89})?[\\w()-]$");
    private static final Pattern AZURE_ML_ENDPOINT_NAME_PATTERN = Pattern.compile("^[a-z][a-z0-9-]{1,30}[a-z0-9]$");

    public static void validateSubscriptionId(String subscriptionId) {
        if (StringUtils.isEmpty((CharSequence)subscriptionId)) {
            throw new IllegalArgumentException("Azure ML subscription should not be empty.");
        }
        if (!AzureMLInputValidator.matches(AZURE_ML_SUBSCRIPTION_ID_PATTERN, subscriptionId)) {
            throw new IllegalArgumentException(String.format("Invalid subscription %s", subscriptionId));
        }
    }

    public static void validateWorkspace(String workspace) {
        if (StringUtils.isEmpty((CharSequence)workspace)) {
            throw new IllegalArgumentException("Azure ML workspace should not be empty.");
        }
        if (!AzureMLInputValidator.matches(AZURE_ML_WORKSPACE_PATTERN, workspace)) {
            throw new IllegalArgumentException(String.format("Invalid workspace %s", workspace));
        }
    }

    public static void validateResourceGroup(String resourceGroup) {
        if (StringUtils.isEmpty((CharSequence)resourceGroup)) {
            throw new IllegalArgumentException("Azure ML resource group should not be empty.");
        }
        if (!AzureMLInputValidator.matches(AZURE_ML_RESOURCE_GROUP_PATTERN, resourceGroup)) {
            throw new IllegalArgumentException(String.format("Invalid resource group %s", resourceGroup));
        }
    }

    public static void validateEndpointName(String endpointName) {
        if (StringUtils.isEmpty((CharSequence)endpointName)) {
            throw new IllegalArgumentException("Azure ML endpoint name should not be empty.");
        }
        if (endpointName.length() > 32) {
            throw ErrorContext.iaef((String)"Endpoint name length is too long. Use less than %s characters.: %s", (Object)32, (Object[])new Object[]{endpointName});
        }
        if (endpointName.length() < 3) {
            throw ErrorContext.iaef((String)"Endpoint name length is too short. Use more than %s characters.: %s", (Object)3, (Object[])new Object[]{endpointName});
        }
        if (!AzureMLInputValidator.matches(AZURE_ML_ENDPOINT_NAME_PATTERN, endpointName)) {
            throw new IllegalArgumentException(String.format("Invalid endpoint name %s", endpointName));
        }
    }
}

