/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.delta;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.warnings.WarningsContext;

public class DeltaFormat {
    public static final String TYPE = "delta";
    public static final FormatMeta<FakeExtractor, Config> META = new FormatMeta<FakeExtractor, Config>(){

        @Override
        public String getType() {
            return DeltaFormat.TYPE;
        }

        @Override
        public String getLabel() {
            return "Delta Lake";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{ParamDesc.advancedSelect("readTemporalMode", "Date handling", "", ParamDesc.enumValues(ORCFileFormatConfig.ReadTemporalMode.class), new String[]{"As date", "As logical type"}).withDefaultValue(ORCFileFormatConfig.ReadTemporalMode.AS_TEMPORAL.name()).withTooltip("Specify how date types are read.")};
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new FakeExtractor();
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            throw new Error("Delta Lake can only be written by Spark");
        }
    };

    public static class FakeExtractor
    implements FormatExtractor {
        @Override
        public void setLimit(ExtractionLimit limit) {
        }

        @Override
        public boolean canSetSchemaForExtractor() {
            return false;
        }

        @Override
        public void setSchema(Schema schema, boolean allowExtraColumns) {
        }

        @Override
        public void setProgressListener(InputSplitProgressListener listener) {
        }

        @Override
        public void setWarningsContext(WarningsContext warnContext) {
        }

        @Override
        public boolean run(StreamsInputSplit in, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
            return false;
        }
    }

    public static class Config
    implements FormatParams {
        public ReadTemporalMode readTemporalMode = ReadTemporalMode.AS_TEMPORAL;

        public static enum ReadTemporalMode {
            AS_DATE,
            AS_TEMPORAL;

        }
    }
}

