/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel.model;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.excel.model.ExcelWorkbook;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.math.DoubleMath;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.NotSupportedException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Cell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DataFormatter;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DateUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Row;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Sheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ExcelWorkbookClassic
implements ExcelWorkbook {
    private static final ZoneId UTC_ZONE_ID = TimeZone.getTimeZone(ZoneOffset.UTC).toZoneId();
    private final DataFormatter formatter = new DataFormatter(Locale.ENGLISH);
    private final Workbook workbook;
    private File tmpFile;
    private static final Logger logger = Logger.getLogger((String)"dku.format.excel");

    public ExcelWorkbookClassic(Workbook workbook, File tmpFile) {
        this.workbook = workbook;
        this.tmpFile = tmpFile;
    }

    @Override
    public void close() throws IOException {
        try {
            this.workbook.close();
        }
        catch (IOException e) {
            logger.error((Object)("Unable to properly close workbook for " + String.valueOf(this.tmpFile)), (Throwable)e);
        }
        if (this.tmpFile != null) {
            ExcelWorkbookClassic.deleteTemporaryFile(this.tmpFile);
            this.tmpFile = null;
        }
    }

    @Override
    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @Override
    public ExcelWorkbook.Sheet getSheetAt(int index) {
        return new SheetImpl(this.workbook.getSheetAt(index));
    }

    @Override
    public int getSheetIndex(String sheetName) {
        return this.workbook.getSheetIndex(sheetName);
    }

    @Override
    public ExcelWorkbook.Sheet getSheet(String sheetName) {
        return new SheetImpl(this.workbook.getSheet(sheetName));
    }

    @Override
    public List<String> listSheetNames() {
        int numberOfSheets = this.workbook.getNumberOfSheets();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < numberOfSheets; ++i) {
            result.add(this.workbook.getSheetAt(i).getSheetName());
        }
        return result;
    }

    @Override
    @Nonnull
    public Iterator<ExcelWorkbook.Sheet> iterator() {
        final Iterator it = this.workbook.iterator();
        return new Iterator<ExcelWorkbook.Sheet>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ExcelWorkbook.Sheet next() {
                return new SheetImpl((Sheet)it.next());
            }
        };
    }

    private static void deleteTemporaryFile(File tmpFile) {
        try {
            DKUFileUtils.forceDelete((File)tmpFile);
        }
        catch (IOException e) {
            logger.error((Object)("Unable to delete temporary file: " + tmpFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private class SheetImpl
    implements ExcelWorkbook.Sheet {
        private final Sheet sheet;

        public SheetImpl(Sheet sheet) {
            this.sheet = sheet;
        }

        @Override
        @NotNull
        public Iterator<ExcelWorkbook.Row> iterator() {
            final Iterator it = this.sheet.iterator();
            return new Iterator<ExcelWorkbook.Row>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public ExcelWorkbook.Row next() {
                    return new RowImpl((Row)it.next());
                }
            };
        }

        @Override
        public String getSheetName() {
            return this.sheet.getSheetName();
        }
    }

    private class CellImpl
    implements ExcelWorkbook.Cell {
        private final Cell cell;

        public CellImpl(Cell cell) {
            this.cell = cell;
        }

        @Override
        public int getRowIndex() {
            return this.cell.getRowIndex();
        }

        @Override
        public int getColumnIndex() {
            return this.cell.getColumnIndex();
        }

        @Override
        public String getFormattedValueAsDateISO(ZoneId timezoneId) {
            return DKUtils.isoFormatReadableByDateFormat((long)this.getTimestampCellValue(timezoneId));
        }

        @Override
        public boolean cellContainsDate() {
            return this.getCellValueType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)this.cell);
        }

        @Override
        public String getFormattedValue(@Nullable Type dssType, ZoneId timezoneId, boolean preserveNumberFormatting) {
            switch (this.getCellValueType()) {
                case BOOLEAN: {
                    Boolean boolValue = this.getBooleanCellValue();
                    return boolValue == null ? "" : String.valueOf(boolValue);
                }
                case NUMERIC: {
                    boolean isFormula;
                    boolean bl = isFormula = this.cell.getCellType() == CellType.FORMULA;
                    if (preserveNumberFormatting && !isFormula) {
                        return ExcelWorkbookClassic.this.formatter.formatCellValue(this.cell);
                    }
                    if (DateUtil.isCellDateFormatted((Cell)this.cell)) {
                        if (dssType != null && dssType.isTemporal()) {
                            if (dssType == Type.DATE) {
                                return DKUtils.isoFormatReadableByDateFormat((long)this.getTimestampCellValue(timezoneId));
                            }
                            if (dssType == Type.DATEONLY) {
                                return DKUtils.isoFormatReadableByDateFormat((long)this.getTimestampCellValue(UTC_ZONE_ID)).substring(0, 10);
                            }
                            return DKUtils.isoFormatReadableByDatetimeNoTzFormat((long)this.getTimestampCellValue(UTC_ZONE_ID));
                        }
                        if (isFormula) {
                            return ExcelWorkbookClassic.this.formatter.createFormat(this.cell).format(this.cell.getDateCellValue());
                        }
                        return ExcelWorkbookClassic.this.formatter.formatCellValue(this.cell);
                    }
                    double d = this.cell.getNumericCellValue();
                    if (DoubleMath.isMathematicalInteger((double)d) && d >= -9.223372036854776E18 && d < 9.223372036854776E18) {
                        return String.valueOf(Math.round(d));
                    }
                    return String.valueOf(d);
                }
                case STRING: {
                    String v = this.cell.getStringCellValue();
                    return StringUtils.isEmpty((CharSequence)v) ? null : v;
                }
                case BLANK: 
                case ERROR: {
                    return null;
                }
                case FORMULA: {
                    logger.error((Object)"Unexpected unresolved formula cell");
                    return null;
                }
            }
            logger.info((Object)("Unknown Excel cell type: " + String.valueOf(this.cell.getCellType())));
            return null;
        }

        @Override
        public boolean isEmpty() {
            CellType cellValueType = this.getCellValueType();
            switch (cellValueType) {
                case BLANK: 
                case ERROR: {
                    return true;
                }
                case BOOLEAN: 
                case NUMERIC: {
                    return false;
                }
                case STRING: {
                    return StringUtils.isEmpty((CharSequence)this.cell.getStringCellValue());
                }
                case FORMULA: {
                    logger.error((Object)"Unexpected unresolved formula cell");
                    return true;
                }
            }
            logger.debug((Object)("Unknown Excel cell type: " + String.valueOf(cellValueType)));
            return true;
        }

        private long getTimestampCellValue(ZoneId timezoneId) {
            return this.cell.getLocalDateTimeCellValue().atZone(timezoneId).toInstant().toEpochMilli();
        }

        private CellType getCellValueType() {
            CellType cellType = this.cell.getCellType();
            if (cellType == CellType.FORMULA) {
                return this.cell.getCachedFormulaResultType();
            }
            return cellType;
        }

        private Boolean getBooleanCellValue() {
            try {
                return this.cell.getBooleanCellValue();
            }
            catch (NotSupportedException e) {
                String v = this.cell.getStringCellValue();
                if (StringUtils.isBlank((CharSequence)v)) {
                    return null;
                }
                if ("0".equals(v)) {
                    return false;
                }
                if ("1".equals(v)) {
                    return true;
                }
                return Boolean.parseBoolean(v);
            }
        }
    }

    private class RowImpl
    implements ExcelWorkbook.Row {
        private final Row row;

        public RowImpl(Row row) {
            this.row = row;
        }

        @Override
        public int getRowNum() {
            return this.row.getRowNum();
        }

        @Override
        @NotNull
        public Iterator<ExcelWorkbook.Cell> iterator() {
            final Iterator it = this.row.iterator();
            return new Iterator<ExcelWorkbook.Cell>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public ExcelWorkbook.Cell next() {
                    return new CellImpl((Cell)it.next());
                }
            };
        }
    }
}

