/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.geo;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.output.StringOutputFormatter;
import com.dataiku.dip.shaker.processors.geo.GeoJSONUtils;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.locationtech.jts.geom.Geometry;

public class GeoJSONOutputFormatter
extends StringOutputFormatter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.csv");
    private Schema outputSchema;
    private JSONWriter wr;
    private String geoColumn;
    private Column geoCD;
    private List<Column> propertyCDs = new ArrayList<Column>();
    private GeometryMeaning geometryMeaning = new GeometryMeaning();
    private GeoPoint geopointMeaning = new GeoPoint();

    public GeoJSONOutputFormatter() {
        super("utf8");
    }

    public void setOutputSchema(Schema schema) {
        this.outputSchema = schema;
    }

    public void header(ColumnFactory cf, Writer sb) {
        this.wr = new JSONWriter((Appendable)sb);
        this.wr.object();
        this.wr.key("type").value((Object)"FeatureCollection");
        this.wr.key("features").array();
        for (SchemaColumn schemaCol : this.outputSchema.getColumns()) {
            if (schemaCol.getType() == Type.GEOMETRY || schemaCol.getType() == Type.GEOPOINT) {
                this.geoColumn = schemaCol.getName();
                continue;
            }
            this.propertyCDs.add(cf.column(schemaCol.getName()));
        }
        if (this.geoColumn == null) {
            throw ErrorContext.iae((String)"No geo column in dataset");
        }
        this.geoCD = cf.column(this.geoColumn);
    }

    public void format(Row row, ColumnFactory cf, Writer sb) {
        String geoVal = row.get(this.geoCD);
        if (StringUtils.isBlank((String)geoVal)) {
            return;
        }
        Geometry geom = this.geometryMeaning.toGeometry(geoVal);
        if (geom == null) {
            geom = this.geopointMeaning.toGeometry(geoVal);
        }
        if (geom == null) {
            this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Unable to write row (invalid geopoint:" + geoVal + ")", logger);
            return;
        }
        this.wr.object().key("type").value((Object)"Feature");
        this.wr.key("geometry").value((Object)new JSONObject(GeoJSONUtils.getGeoJSON(geom)));
        this.wr.key("properties").object();
        for (Column column : this.propertyCDs) {
            Object castValue;
            Type type = this.outputSchema.getColumn(column.getName()).getType();
            String value = row.get(column);
            if (StringUtils.isBlank((String)value)) continue;
            try {
                castValue = type.isInteger() ? Integer.valueOf(Integer.parseInt(value)) : (type.isFloatingPoint() ? Double.valueOf(Double.parseDouble(value)) : (type == Type.BOOLEAN ? Boolean.valueOf(Boolean.parseBoolean(value)) : (!type.isPrimitive() ? (type == Type.ARRAY ? new JSONArray(value) : new JSONObject(value)) : value)));
            }
            catch (NumberFormatException | JSONException ignored) {
                castValue = value;
            }
            this.wr.key(column.getName()).value(castValue);
        }
        this.wr.endObject();
        this.wr.endObject();
    }

    public void footer(ColumnFactory cf, Writer sb) throws Exception {
        this.wr.endArray();
        this.wr.endObject();
    }

    public void cancel(OutputStream os) throws Exception {
    }
}

