/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.charts;

import com.dataiku.dip.analysis.docgen.model.OriginAnalysisDetails;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.charts.execution.ChartExportScriptRunner;
import com.dataiku.dip.graphicsexport.charts.execution.DomElementEnrichedExport;
import com.dataiku.dip.graphicsexport.charts.execution.DomElementExportPostProcessor;
import com.dataiku.dip.graphicsexport.charts.model.DoctorPages;
import com.dataiku.dip.graphicsexport.charts.model.DomElementsExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DomElementsExportService
extends BaseExportService<DomElementsExport, ExportFormat, DomElementEnrichedExport> {
    private static final Logger logger = Logger.getLogger((String)"dku.analysis.docgen");

    public DomElementsExport buildExport(String rootUrl, String projectKey, List<DomElementsExport.Target> puppeteerPlaceholders, InfoMessage.InfoMessages messages) {
        ExportFormat format = new ExportFormat();
        format.paperSize = ExportFormat.PaperSize.CUSTOM;
        format.orientation = ExportFormat.Orientation.LANDSCAPE;
        format.fileType = ExportFormat.FileType.PNG;
        format.width = 1200;
        format.height = 800;
        return new DomElementsExport(rootUrl, projectKey, format, puppeteerPlaceholders, messages);
    }

    @Override
    protected BaseExportService.ExportFutureThread newFutureThread(AuthCtx user, DomElementsExport export) throws IOException, DKUSecurityException {
        return new ChartExportFutureThread(user, (DomElementEnrichedExport)this.checkAndEnrichExport(user, export, Privileges.ProjectLevelPrivilegeType.READ_CONF), export.messages);
    }

    @Override
    protected DomElementEnrichedExport checkAndEnrichExport(DomElementsExport export, HrefContext hrefContext, boolean browserSandBoxing) throws IOException {
        Preconditions.checkArgument((!export.puppeteerPlaceholders.isEmpty() ? 1 : 0) != 0, (Object)"At least one element must be specified.");
        ArrayList<DomElementEnrichedExport.Target> exportItems = new ArrayList<DomElementEnrichedExport.Target>();
        for (DomElementsExport.Target puppeteerPlaceholder : export.puppeteerPlaceholders) {
            exportItems.add(this.checkAndEnrichTarget(export.projectKey, puppeteerPlaceholder, hrefContext));
        }
        return new DomElementEnrichedExport(export.rootUrl, export.exportId, export.projectKey, this.checkAndEnrichExportFormat(export.format, DomElementsExport.SCREEN_RANGE_W, DomElementsExport.SCREEN_RANGE_H), exportItems, browserSandBoxing);
    }

    @Override
    protected ExportFormat newExportFormat() {
        return new ExportFormat();
    }

    private DomElementEnrichedExport.Target checkAndEnrichTarget(String projectKey, DomElementsExport.Target targetElement, HrefContext hrefContext) throws IOException {
        Preconditions.checkArgument((targetElement.stepList != null ? 1 : 0) != 0, (Object)"All charts targets must contains a valid chart def.");
        Preconditions.checkArgument((targetElement.stepList.size() > 0 ? 1 : 0) != 0, (Object)"All charts targets must contains a valid chart def.");
        DomElementEnrichedExport.Target target = new DomElementEnrichedExport.Target();
        target.puppeteerConfigName = targetElement.puppeteerConfigName;
        target.placeholderName = targetElement.placeholderName;
        target.steps = targetElement.stepList;
        FullModelId fmi = targetElement.fmi;
        FullModelId.Type fmiType = fmi.type;
        DoctorPages doctorPage = targetElement.doctorPage;
        MLTask mlTask = fmi.getHeadMLTask();
        MLTask.MLTaskType taskType = mlTask.taskType;
        if (fmi.isExternalMLflowModelVersion()) {
            Object routeSuffix = "";
            if (StringUtils.isNotBlank((String)targetElement.routeSuffix)) {
                String tab = this.getReportTabPrefix(mlTask);
                routeSuffix = tab + targetElement.routeSuffix;
            }
            target.url = hrefContext.savedModelReport(projectKey, fmi.getSavedModelID(), fmi.getSavedModelVersionID(), taskType, (String)routeSuffix, true);
        } else {
            OriginAnalysisDetails analysisDetails = new OriginAnalysisDetails(fmi, mlTask);
            if (FullModelId.Type.ANALYSIS.equals((Object)fmiType) && !StringUtils.isEmpty((String)fmi.getProjectKey())) {
                projectKey = fmi.getProjectKey();
            } else if (FullModelId.Type.SAVED.equals((Object)fmiType) && !StringUtils.isEmpty((String)fmi.getSavedModelProjectKey())) {
                projectKey = fmi.getSavedModelProjectKey();
            }
            if (DoctorPages.REPORT.equals((Object)doctorPage)) {
                Object routeSuffix = targetElement.routeSuffix;
                if (StringUtils.isNotBlank((String)targetElement.routeSuffix)) {
                    String tab = this.getReportTabPrefix(mlTask);
                    routeSuffix = tab + targetElement.routeSuffix;
                }
                if (FullModelId.Type.SAVED.equals((Object)fmiType)) {
                    target.url = hrefContext.savedModelReport(projectKey, fmi.getSavedModelID(), fmi.getSavedModelVersionID(), taskType, (String)routeSuffix, true);
                } else if (FullModelId.Type.ANALYSIS.equals((Object)fmiType)) {
                    target.url = hrefContext.analysisReport(projectKey, analysisDetails.analysisId, taskType, analysisDetails.mlTaskId, analysisDetails.sessionId, fmi.getPreprocessingId(), fmi.getModelId(), (String)routeSuffix, true);
                }
            } else if (DoctorPages.RESULTS.equals((Object)doctorPage)) {
                target.url = hrefContext.analysisResults(projectKey, analysisDetails.analysisId, taskType, analysisDetails.mlTaskId);
            } else if (DoctorPages.DESIGN.equals((Object)doctorPage)) {
                Object routeSuffix = targetElement.routeSuffix;
                if (StringUtils.isNotBlank((String)targetElement.routeSuffix)) {
                    String tab = this.getDesignTabPrefix(mlTask);
                    routeSuffix = tab + "-" + targetElement.routeSuffix;
                }
                target.url = hrefContext.analysisDesign(projectKey, analysisDetails.analysisId, taskType, analysisDetails.mlTaskId, (String)routeSuffix);
            } else {
                logger.error((Object)"The doctor page specified for this FullModelId doesn't exist");
            }
        }
        return target;
    }

    private String getReportTabPrefix(MLTask mlTask) {
        if (MLTask.MLTaskType.PREDICTION.equals((Object)mlTask.taskType)) {
            if (mlTask instanceof PredictionMLTask.DeepHubPredictionMLTask) {
                return "deephub-";
            }
            return "tabular-";
        }
        return "";
    }

    private String getDesignTabPrefix(MLTask mlTask) {
        switch (mlTask.taskType) {
            case CLUSTERING: {
                return "clustering";
            }
            case PREDICTION: {
                switch (((PredictionMLTask)mlTask).predictionType) {
                    case REGRESSION: 
                    case MULTICLASS: 
                    case BINARY_CLASSIFICATION: {
                        return "classical";
                    }
                    case TIMESERIES_FORECAST: {
                        return "timeseries";
                    }
                    case DEEP_HUB_IMAGE_OBJECT_DETECTION: 
                    case DEEP_HUB_IMAGE_CLASSIFICATION: {
                        return "deephub";
                    }
                    case CAUSAL_REGRESSION: 
                    case CAUSAL_BINARY_CLASSIFICATION: {
                        return "causal";
                    }
                }
                throw new IllegalArgumentException("Unsupported prediction type: " + String.valueOf((Object)((PredictionMLTask)mlTask).predictionType));
            }
        }
        throw new IllegalArgumentException("Unsupported task type: " + String.valueOf((Object)mlTask.taskType));
    }

    private class ChartExportFutureThread
    extends BaseExportService.ExportFutureThread {
        private InfoMessage.InfoMessages messages;

        public ChartExportFutureThread(AuthCtx user, DomElementEnrichedExport export, InfoMessage.InfoMessages messages) {
            super(user, export);
            this.messages = messages;
        }

        @Override
        protected int getExportTargetCount() {
            int size = ((DomElementEnrichedExport)this.export).elements.size();
            return size > 1 ? size : -1;
        }

        @Override
        protected String getTitle() {
            return "Resolving placeholders";
        }

        @Override
        protected void executeScript(InternalAPIKeysService.APIKey key, File rawExportDirectory, FutureProgressState progressState) throws IOException, InterruptedException {
            ChartExportScriptRunner exportScriptRunner = new ChartExportScriptRunner((DomElementEnrichedExport)this.export, rawExportDirectory, key, progressState, this.messages);
            exportScriptRunner.execute();
        }

        @Override
        protected File postProcessGeneratedFiles(File rawExportDirectory, File postProcessDirectory, File finalExportDirectory) throws Exception {
            return new DomElementExportPostProcessor(rawExportDirectory, postProcessDirectory, finalExportDirectory).execute();
        }

        @Override
        protected FuturePayload buildExportFuturePayload() {
            return this.buildExportFuturePayload("chart", this.export.format.fileType.toString());
        }
    }
}

