/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.wikis;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.model.EnrichedExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.wikis.execution.WikiExportPostProcessor;
import com.dataiku.dip.graphicsexport.wikis.execution.WikiExportScriptRunner;
import com.dataiku.dip.graphicsexport.wikis.model.WikiEnrichedExport;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExport;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExportTarget;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.WikisService;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WikiExportService
extends BaseExportService<WikiExport, ExportFormat, WikiEnrichedExport> {
    @Autowired
    private WikisService wikisService;
    @Autowired
    private TransactionService transactionService;

    @Override
    protected BaseExportService.ExportFutureThread newFutureThread(AuthCtx user, WikiExport export) throws IOException, DKUSecurityException {
        return new WikiExportFutureThread(user, (EnrichedExport)this.checkAndEnrichExport(user, export, Privileges.ProjectLevelPrivilegeType.READ_CONF));
    }

    @Override
    protected ExportFormat newExportFormat() {
        return new ExportFormat();
    }

    @Override
    protected WikiEnrichedExport checkAndEnrichExport(WikiExport export, HrefContext hrefContext, boolean browserSandBoxing) throws IOException {
        List<String> articleIds;
        boolean fullWikiExport;
        boolean bl = fullWikiExport = export.articleIds == null || export.articleIds.isEmpty();
        if (fullWikiExport) {
            Preconditions.checkArgument((boolean)export.exportChildren, (Object)"Export Children option must be true when exporting the whole wiki.");
            articleIds = this.wikisService.getRootArticlesIds(export.projectKey);
        } else {
            articleIds = export.articleIds;
        }
        if (articleIds.isEmpty()) {
            throw new IllegalStateException("No wiki article to export in project " + export.projectKey);
        }
        ArrayList<WikiExportTarget> exportedArticles = new ArrayList<WikiExportTarget>();
        for (String articleId : articleIds) {
            exportedArticles.add(this.buildWikiExportTarget(articleId, export.projectKey, export.exportChildren));
        }
        String wikiHomeURL = hrefContext.article(export.projectKey, this.wikisService.getWiki((String)export.projectKey).homeArticleId, true);
        return new WikiEnrichedExport(export, exportedArticles, hrefContext.root(), wikiHomeURL, browserSandBoxing, fullWikiExport);
    }

    private WikiExportTarget buildWikiExportTarget(String articleId, String projectKey, boolean exportChildren) throws IOException {
        Article article = this.wikisService.getArticleMandatoryUnsafe(projectKey, articleId);
        WikiExportTarget target = new WikiExportTarget();
        target.article = article;
        target.children = new ArrayList<WikiExportTarget>();
        if (exportChildren) {
            for (String childId : this.wikisService.getArticleChildrenIds(projectKey, articleId)) {
                target.children.add(this.buildWikiExportTarget(childId, projectKey, true));
            }
        }
        return target;
    }

    private int countArticleAndItsChildren(WikiExportTarget target) {
        int count = 1;
        if (target.children != null) {
            for (WikiExportTarget child : target.children) {
                count += this.countArticleAndItsChildren(child);
            }
        }
        return count;
    }

    private class WikiExportFutureThread
    extends BaseExportService.ExportFutureThread {
        public WikiExportFutureThread(AuthCtx user, EnrichedExport export) {
            super(user, export);
        }

        @Override
        protected String getTitle() {
            return "Exporting Wiki";
        }

        @Override
        protected int getExportTargetCount() {
            int count = 0;
            for (WikiExportTarget article : ((WikiEnrichedExport)this.export).articles) {
                count += WikiExportService.this.countArticleAndItsChildren(article);
            }
            return count;
        }

        @Override
        protected File postProcessGeneratedFiles(File rawExportDirectory, File postProcessDirectory, File finalExportDirectory) throws Exception {
            return new WikiExportPostProcessor((WikiEnrichedExport)this.export, rawExportDirectory, postProcessDirectory, finalExportDirectory, WikiExportService.this.wikisService, WikiExportService.this.transactionService).execute();
        }

        @Override
        protected void executeScript(InternalAPIKeysService.APIKey key, File rawExportDirectory, FutureProgressState progressState) throws IOException, InterruptedException {
            new WikiExportScriptRunner(this.export, rawExportDirectory, key, progressState).execute();
        }

        @Override
        protected FuturePayload buildExportFuturePayload() {
            return this.buildExportFuturePayload("wiki", "PDF");
        }
    }
}

