/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.wikis.execution;

import com.dataiku.dip.graphicsexport.wikis.execution.PdfLink;
import com.dataiku.dip.graphicsexport.wikis.model.WikiEnrichedExport;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.WikisService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public class WikiArticleLinksEditor {
    private final WikiEnrichedExport export;
    private final Map<String, String> attachmentsMap;
    private final TransactionService transactionService;
    private final WikisService wikisService;
    private final String externalUrl;
    private final Pattern extractArticleNameOrId;
    private final Pattern extractAttachmentId;
    private final Pattern removeFullScreenMode;
    private final Pattern extractInternalLink;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.export.wiki.links");

    public WikiArticleLinksEditor(WikiEnrichedExport export, String externalUrl, Map<String, String> attachmentsMap, WikisService wikisService, TransactionService transactionService) {
        this.export = export;
        this.attachmentsMap = attachmentsMap;
        this.wikisService = wikisService;
        this.transactionService = transactionService;
        this.externalUrl = externalUrl;
        this.extractArticleNameOrId = Pattern.compile(String.format("^%s/projects/(?<project>[\\w]+)/wiki/(?<id>[^?/#]+)(/(?<name>[^?/#]*))?(\\?[^?/#]*)?(#(?<anchor>[^?/#]*))?", export.instanceUrl));
        this.extractAttachmentId = Pattern.compile(String.format("^%s/dip/api/projects/wikis/get-uploaded-file/.*?projectKey=(?<project>[\\w]+)&uploadId=(?<id>[\\w]{%d})", export.instanceUrl, 12));
        this.removeFullScreenMode = Pattern.compile(String.format("^%s(?<url>/.*)\\?fullScreen", export.instanceUrl));
        this.extractInternalLink = Pattern.compile(String.format("^%s(?<url>/.*)", export.instanceUrl));
    }

    public void editInternalLinks(PDDocument document, Map<String, PDOutlineItem> bookmarkMap) throws IOException {
        for (PDPage page : document.getPages()) {
            for (PDAnnotation annotation : page.getAnnotations(a -> a instanceof PDAnnotationLink)) {
                PDAnnotationLink link = (PDAnnotationLink)annotation;
                Optional<PdfLink> newLink = this.buildInternalLink(link, bookmarkMap);
                if (!newLink.isPresent()) continue;
                this.editLink(bookmarkMap, link, newLink.get());
            }
        }
    }

    private void editLink(Map<String, PDOutlineItem> bookmarkMap, PDAnnotationLink link, PdfLink newLink) throws IOException {
        PDActionURI uri = (PDActionURI)link.getAction();
        if (newLink.isInternalLink()) {
            if (bookmarkMap.containsKey(newLink.getArticleId())) {
                PDDestination destination = bookmarkMap.get(newLink.getArticleId()).getDestination();
                link.setDestination(destination);
                uri.setURI(null);
            }
        } else {
            uri.setURI(newLink.getUrl());
        }
    }

    @VisibleForTesting
    Optional<PdfLink> buildInternalLink(PDAnnotationLink link, Map<String, PDOutlineItem> bookmarkMap) throws IOException {
        Matcher attachmentIdMatcher;
        PDAction action = link.getAction();
        if (!(action instanceof PDActionURI)) {
            return Optional.empty();
        }
        String url = ((PDActionURI)action).getURI();
        if (!url.startsWith(this.export.instanceUrl)) {
            return Optional.empty();
        }
        Matcher articleNameMatcher = this.extractArticleNameOrId.matcher(url);
        if (articleNameMatcher.find()) {
            return this.buildLinkToArticle(articleNameMatcher, url, bookmarkMap);
        }
        if (this.export.exportAttachments && (attachmentIdMatcher = this.extractAttachmentId.matcher(url)).find() && this.attachmentsMap.containsKey(attachmentIdMatcher.group("id"))) {
            return Optional.of(PdfLink.urlLink(this.attachmentsMap.get(attachmentIdMatcher.group("id"))));
        }
        return this.buildLinkWithExternalUrl(url);
    }

    private Optional<PdfLink> buildLinkToArticle(Matcher articleNameMatcher, String url, Map<String, PDOutlineItem> bookmarkMap) throws IOException {
        String smartName;
        Optional<Article> article;
        if (articleNameMatcher.group("project").equals(this.export.projectKey) && (article = this.getArticleFromName(smartName = URLDecoder.decode(articleNameMatcher.group("id"), "UTF-8"))).isPresent() && bookmarkMap.containsKey(article.get().id)) {
            return Optional.of(PdfLink.articleLink(article.get().id));
        }
        return this.buildLinkWithoutFullScreen(url);
    }

    private Optional<Article> getArticleFromName(String encodedSmartName) throws IOException {
        Article article;
        String smartName = URLDecoder.decode(encodedSmartName, "UTF-8");
        try (Transaction ignored = this.transactionService.beginRead();){
            article = this.wikisService.getSmartArticleMandatoryUnsafe(this.export.projectKey, smartName);
        }
        catch (NotFoundException e) {
            this.logger.warnV("Could not edit internal link to article '%s' as the article cannot be found in project %s", new Object[]{smartName, this.export.projectKey});
            return Optional.empty();
        }
        return Optional.of(article);
    }

    private Optional<PdfLink> buildLinkWithoutFullScreen(String url) {
        Matcher matcher = this.removeFullScreenMode.matcher(url);
        if (matcher.find()) {
            return Optional.of(PdfLink.urlLink((this.externalUrl != null ? this.externalUrl : this.export.instanceUrl) + matcher.group("url")));
        }
        return Optional.empty();
    }

    private Optional<PdfLink> buildLinkWithExternalUrl(String url) {
        Matcher matcher = this.extractInternalLink.matcher(url);
        if (matcher.find() && this.externalUrl != null) {
            return Optional.of(PdfLink.urlLink(this.externalUrl + matcher.group("url")));
        }
        return Optional.empty();
    }
}

