/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.wikis.execution;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.graphicsexport.execution.GraphicsExportUtils;
import com.dataiku.dip.graphicsexport.wikis.execution.WikiArticleLinksEditor;
import com.dataiku.dip.graphicsexport.wikis.execution.WikiArticleMerger;
import com.dataiku.dip.graphicsexport.wikis.model.WikiEnrichedExport;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExportTarget;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class WikiExportPostProcessor {
    private final WikiEnrichedExport export;
    private final File finalDirectory;
    private final File postProcessDirectory;
    private final File rawExportDirectory;
    private final Map<String, String> attachmentsMap;
    private final WikisService wikisService;
    private final TransactionService transactionService;

    public WikiExportPostProcessor(WikiEnrichedExport export, File rawExportDirectory, File postProcessDirectory, File finalDirectory, WikisService wikisService, TransactionService transactionService) {
        this.export = export;
        this.rawExportDirectory = rawExportDirectory;
        this.postProcessDirectory = postProcessDirectory;
        this.finalDirectory = finalDirectory;
        this.transactionService = transactionService;
        this.wikisService = wikisService;
        this.attachmentsMap = new HashMap<String, String>();
    }

    public File execute() throws IOException {
        if (this.export.exportAttachments && this.exportContainsAttachment()) {
            File exportedFile = new File(this.finalDirectory, this.getExportedFileName() + ".zip");
            try (ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(exportedFile));){
                for (WikiExportTarget target : this.export.articles) {
                    this.addArticleAttachments(zOut, target, "attachments");
                }
                File pdf = this.generatePDF(this.postProcessDirectory);
                this.addFileToZip(zOut, pdf, this.getExportedFileName() + ".pdf");
            }
            return exportedFile;
        }
        return this.generatePDF(this.finalDirectory);
    }

    private void addArticleAttachments(ZipOutputStream zOut, WikiExportTarget target, String path) throws IOException {
        path = (String)path + "/" + this.sanitize(target.article.name);
        for (Article.ArticleAttachment attachment : target.article.attachments) {
            if (attachment.attachmentType != Article.ArticleAttachmentType.FILE) continue;
            String filePath = (String)path + "/" + this.getAttachmentFileName(attachment);
            this.attachmentsMap.put(attachment.smartId, filePath);
            this.addFileToZip(zOut, this.getAttachmentFile(attachment), filePath);
        }
        for (WikiExportTarget child : target.children) {
            this.addArticleAttachments(zOut, child, (String)path);
        }
    }

    private void addFileToZip(ZipOutputStream zout, File file, String filePath) throws IOException {
        zout.putNextEntry(new ZipEntry(filePath));
        FileUtils.copyFile((File)file, (OutputStream)zout);
        zout.closeEntry();
    }

    private String getExportedFileName() {
        return this.export.fullWikiExport ? this.export.projectKey + "-wiki" : this.sanitize(this.export.articles.get((int)0).article.name);
    }

    private File generatePDF(File directory) throws IOException {
        assert (this.export.articles.size() > 0);
        String externalUrl = UrlUtil.getDSSExternalRootUrl(ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN());
        WikiArticleLinksEditor linksEditor = new WikiArticleLinksEditor(this.export, externalUrl, this.attachmentsMap, this.wikisService, this.transactionService);
        WikiArticleMerger merger = new WikiArticleMerger(this.rawExportDirectory, linksEditor);
        File exportedFile = new File(directory, this.getExportedFileName() + ".pdf");
        merger.mergeFullPDFs(this.export.articles, exportedFile);
        return exportedFile;
    }

    private String sanitize(String str) {
        return GraphicsExportUtils.sanitize(str);
    }

    private File getAttachmentFile(Article.ArticleAttachment attachment) throws IOException {
        return this.wikisService.getUploadedFile(this.export.projectKey, attachment.smartId);
    }

    private String getAttachmentFileName(Article.ArticleAttachment attachment) throws IOException {
        return attachment.smartId + "-" + this.wikisService.getUploadMeta((String)this.export.projectKey, (String)attachment.smartId).fileName;
    }

    private boolean exportContainsAttachment() {
        for (WikiExportTarget target : this.export.articles) {
            if (!this.articleOrChildrenHasAttachment(target)) continue;
            return true;
        }
        return false;
    }

    private boolean articleOrChildrenHasAttachment(WikiExportTarget target) {
        if (this.articleHasAttachment(target.article)) {
            return true;
        }
        if (this.export.exportChildren) {
            for (WikiExportTarget child : target.children) {
                if (!this.articleOrChildrenHasAttachment(child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean articleHasAttachment(Article article) {
        for (Article.ArticleAttachment attachment : article.attachments) {
            if (attachment.attachmentType != Article.ArticleAttachmentType.FILE) continue;
            return true;
        }
        return false;
    }
}

