/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.PartitionSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HiveMetadataTools {
    public static boolean isSamePartitionPath(TableSchema tableSchema, Partition partition, String location) {
        List<Integer> dimensionIndices;
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        if ((dimensionIndices = HiveMetadataTools.getPartitioningDimensionIndices(tableSchema, partition.getScheme())) == null) {
            return false;
        }
        for (PartitionSchema tablePartitionSchema : tableSchema.partitions) {
            ArrayList partitionKeys = Lists.newArrayList();
            for (int partitionIndex : dimensionIndices) {
                partitionKeys.add((String)tablePartitionSchema.keys.get(partitionIndex));
            }
            Partition tablePartition = PartitionFactory.fromIdentifier(partition.getScheme(), Joiner.on((String)"|").join((Iterable)partitionKeys));
            String partitionLocation = tablePartitionSchema.location;
            if (partitionLocation.endsWith("/")) {
                partitionLocation = partitionLocation.substring(0, partitionLocation.length() - 1);
            }
            if (!tablePartition.equals((Object)partition)) continue;
            return partitionLocation.equals(location);
        }
        return false;
    }

    public static List<Integer> getPartitioningDimensionIndices(TableSchema tableSchema, PartitioningScheme partitioningScheme) {
        HashMap partitionColumnIndices = Maps.newHashMap();
        for (int i = 0; i < tableSchema.partitionColumns.size(); ++i) {
            partitionColumnIndices.put(((ColumnSchema)tableSchema.partitionColumns.get((int)i)).name, i);
        }
        ArrayList dimensionIndices = Lists.newArrayList();
        for (String dimensionName : partitioningScheme.getDimensionNames()) {
            Integer index = (Integer)partitionColumnIndices.get(dimensionName);
            if (index == null && (index = (Integer)partitionColumnIndices.get(dimensionName.toLowerCase())) == null) {
                return null;
            }
            dimensionIndices.add(index);
        }
        return dimensionIndices;
    }

    public static String getPartitionSpec(Partition p) {
        ArrayList<CallSite> specs = new ArrayList<CallSite>();
        for (String dimName : p.getScheme().getDimensionNames()) {
            DimensionValue dimVal = (DimensionValue)p.getDimensionValues().get(dimName);
            String spec = "`" + dimName + "`='" + dimVal.id() + "'";
            specs.add((CallSite)((Object)spec));
        }
        return "(" + StringUtils.join(specs, (String)",") + ")";
    }

    public static String getUnescapedHivePartitionName(Partition p) {
        ArrayList<CallSite> specs = new ArrayList<CallSite>();
        for (String dimName : p.getScheme().getDimensionNames()) {
            DimensionValue dimVal = (DimensionValue)p.getDimensionValues().get(dimName);
            String spec = dimName + "=" + dimVal.id();
            specs.add((CallSite)((Object)spec));
        }
        return StringUtils.join(specs, (String)",");
    }

    private HiveMetadataTools() {
    }
}

