/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.warnings.RecordContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFormatExtractor
implements FormatExtractor {
    public static final String PARAM_skipRowsBeforeHeader = "skipRowsBeforeHeader";
    public static final String PARAM_parseHeaderRow = "parseHeaderRow";
    public static final String PARAM_skipRowsAfterHeader = "skipRowsAfterHeader";
    protected boolean allowExtraColumns;
    protected Schema schema;
    protected ArrayList<Type> types;
    protected ExtractionLimit limit;
    protected WarningsContext warnContext = new WarningsContext();
    protected InputSplitProgressListener listener;
    protected RecordContext rc = new RecordContext();

    @Override
    public void setLimit(ExtractionLimit limit) {
        this.limit = limit;
    }

    @Override
    public boolean canSetSchemaForExtractor() {
        return false;
    }

    @Override
    public void setSchema(Schema schema, boolean allowExtraColumns) {
        this.schema = schema;
        this.types = new ArrayList();
        for (SchemaColumn column : schema.getColumns()) {
            this.types.add(column.getType());
        }
        this.allowExtraColumns = allowExtraColumns;
    }

    @Override
    public void setProgressListener(InputSplitProgressListener listener) {
        this.listener = listener;
    }

    @Override
    public void setWarningsContext(WarningsContext warnContext) {
        if (warnContext != null) {
            this.warnContext = warnContext;
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public List<Type> getTypes() {
        return this.types;
    }
}

