/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.input.formats.CompressibleFormatParams;
import com.dataiku.dip.utils.Params;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.beans.Transient;
import java.io.Serializable;
import java.util.List;

public class CSVFormatConfig
extends CompressibleFormatParams
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final int DEFAULT_MAX_ROW_CHARS = 100000000;
    public static final int DEFAULT_CELL_CHARS_WARN_THRESHOLD = 500000;
    public CSVStyle style;
    public String charset = "utf8";
    private String separator;
    private String quoteChar = "\"";
    private String escapeChar = "\\";
    private Integer maxRowChars = null;
    public String arrayItemSeparator;
    public String mapKeySeparator;
    public DateSerializationFormat dateSerializationFormat = DateSerializationFormat.ISO;
    public CSVComplexTypeSerialization arrayMapFormat = CSVComplexTypeSerialization.json;
    public List<String> hiveSeparators = Lists.newArrayList((Object[])new String[]{"\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b"});
    public int skipRowsBeforeHeader;
    public boolean parseHeaderRow;
    public int skipRowsAfterHeader;
    public int probableNumberOfRecords;
    public boolean normalizeBooleans;
    public boolean normalizeDoubles = true;
    public ReadAdditionalColumnsBehavior readAdditionalColumnsBehavior = ReadAdditionalColumnsBehavior.INSERT_IN_DATA_WARNING;
    public ReadMissingColumnsBehavior readMissingColumnsBehavior = ReadMissingColumnsBehavior.DISCARD_SILENT;
    public StorageTypeVerifier.DataTypeMismatchBehavior readDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;
    public StorageTypeVerifier.DataTypeMismatchBehavior writeDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;
    public FileReadFailureBehavior fileReadFailureBehavior = FileReadFailureBehavior.FAIL;

    public static CSVFormatConfig getStandardTabUNIXFormat() {
        CSVFormatConfig ret = new CSVFormatConfig();
        ret.style = CSVStyle.UNIX;
        ret.separator = "\t";
        ret.quoteChar = "\"";
        ret.escapeChar = "\\";
        ret.parseHeaderRow = false;
        return ret;
    }

    public static CSVFormatConfig getStandardTabExcelFormat() {
        CSVFormatConfig ret = new CSVFormatConfig();
        ret.style = CSVStyle.EXCEL;
        ret.separator = "\t";
        ret.quoteChar = "\"";
        ret.parseHeaderRow = false;
        return ret;
    }

    public void setSeparatorStr(String separator) {
        this.separator = separator;
    }

    public void setEscapeStr(String s) {
        this.escapeChar = s;
    }

    public void setQuoteStr(String s) {
        this.quoteChar = s;
    }

    @Transient
    public String getSeparatorStr() {
        return this.separator;
    }

    @Transient
    public char getSeparatorChar() {
        Preconditions.checkNotNull((Object)this.separator, (Object)"separator is not specified");
        return Params.getAsChar((String)this.separator);
    }

    @Transient
    public char getQuoteChar() {
        Preconditions.checkNotNull((Object)this.separator, (Object)"quoteChar is not specified");
        return Params.getAsChar((String)this.quoteChar);
    }

    @Transient
    public char getEscapeChar() {
        Preconditions.checkNotNull((Object)this.escapeChar, (Object)"escapeChar is not specified");
        return Params.getAsChar((String)this.escapeChar);
    }

    @Transient
    public char getArrayItemSeparatorChar() {
        Preconditions.checkNotNull((Object)this.arrayItemSeparator, (Object)"arrayItemSeparator is not specified");
        return Params.getAsChar((String)this.arrayItemSeparator);
    }

    @Transient
    public char getMapKeySeparatorChar() {
        Preconditions.checkNotNull((Object)this.mapKeySeparator, (Object)"mapKeySeparator is not specified");
        return Params.getAsChar((String)this.mapKeySeparator);
    }

    public Integer getMaxRowChars() {
        return this.maxRowChars;
    }

    public void setMaxRowChars(int maxRowChars) {
        this.maxRowChars = maxRowChars;
    }

    public static enum DateSerializationFormat {
        ISO,
        ISO_STRICT,
        ISO_FORCED_UTC,
        HIVE;

    }

    public static enum CSVComplexTypeSerialization {
        hive,
        delimited,
        json;

    }

    public static enum ReadAdditionalColumnsBehavior {
        INSERT_IN_DATA_SILENT,
        INSERT_IN_DATA_WARNING,
        DISCARD_SILENT,
        DISCARD_WARNING,
        ERROR;

    }

    public static enum ReadMissingColumnsBehavior {
        DISCARD_SILENT,
        DISCARD_WARNING,
        ERROR;

    }

    public static enum FileReadFailureBehavior {
        FAIL,
        WARN_AND_CONTINUE;

    }

    public static enum CSVStyle {
        UNIX("unix"),
        EXCEL("excel"),
        ESCAPE_ONLY_NO_QUOTE("escape_only_no_quote"),
        NO_ESCAPE_NO_QUOTE("no_escape_no_quote");

        private String name;

        public String toString() {
            return this.name;
        }

        private CSVStyle(String name) {
            this.name = name;
        }
    }
}

