/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVParser;
import com.dataiku.dip.input.formats.vendor.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class UNIXStyleCSVParser
implements CSVParser {
    private CSVReader reader;

    public UNIXStyleCSVParser(Reader reader, char delimiter, char quoteChar, Character escapeChar) {
        this(reader, delimiter, quoteChar, escapeChar, null);
    }

    public UNIXStyleCSVParser(Reader reader, CSVFormatConfig conf) {
        this(reader, conf.getSeparatorChar(), conf.getQuoteChar(), Character.valueOf(conf.getEscapeChar()), conf.getMaxRowChars());
    }

    private UNIXStyleCSVParser(Reader reader, char delimiter, char quoteChar, Character escapeChar, Integer maxRowChars) {
        this.reader = new CSVReader(reader, Character.valueOf(delimiter), Character.valueOf(quoteChar), escapeChar, null, null, null, maxRowChars);
    }

    @Override
    public boolean next(List<String> out) throws IOException {
        out.clear();
        String[] line = this.reader.readNext();
        if (line == null) {
            return false;
        }
        for (String s : line) {
            out.add(s);
        }
        return true;
    }
}

