/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.serde;

import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DSSRowObjectInspector;

public class DSSInspectionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public DSSInspectionException(DSSBaseInspector dssInspector, String msg, Throwable t) {
        super(DSSInspectionException.enhanceMessage(msg, dssInspector), t);
    }

    public DSSInspectionException(DSSBaseInspector dssInspector, Throwable t) {
        this(dssInspector, "[" + t.getClass().getSimpleName() + "] " + t.getMessage(), t);
    }

    public DSSInspectionException(DSSBaseInspector dssInspector, String msg) {
        this(dssInspector, msg, null);
    }

    private static String enhanceMessage(String msg, DSSBaseInspector dssInspector) {
        String columnName = DSSInspectionException.findColumnName(dssInspector);
        if (columnName != null) {
            msg = (String)msg + ", in column " + columnName;
        }
        return msg;
    }

    private static String findColumnName(DSSBaseInspector inspector) {
        DSSBaseInspector child = null;
        while (inspector != null && !(inspector instanceof DSSRowObjectInspector)) {
            child = inspector;
            inspector = inspector.getParent();
        }
        if (inspector instanceof DSSRowObjectInspector) {
            DSSRowObjectInspector rowInspector = (DSSRowObjectInspector)inspector;
            for (DSSRowObjectInspector.Field sf : rowInspector.getAllStructFieldRefs()) {
                if (sf.getFieldObjectInspector() != child) continue;
                return sf.getCaseSensitiveFieldName();
            }
        }
        return null;
    }
}

