/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetSchemaBuilder;
import com.dataiku.dip.input.formats.parquet.ReusableParquetRow;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

class DSSRowWriteSupport
extends WriteSupport<ReusableParquetRow> {
    private static Logger logger = Logger.getLogger(DSSRowWriteSupport.class);
    private final boolean lowerCaseIdentifiers;
    private final ParquetFormatConfig.Flavor flavor;
    private Schema schema;
    private WarningsContext warningsContext;
    private List<SchemaColumn> schemaColumns;
    private ColumnFactory columnFactory;
    private List<Column> columns;
    private MessageType mt;
    private RecordConsumer recordConsumer;

    public DSSRowWriteSupport(WarningsContext wc, boolean lowerCaseIdentifiers, ParquetFormatConfig.Flavor flavor) {
        this.warningsContext = wc;
        this.lowerCaseIdentifiers = lowerCaseIdentifiers;
        this.flavor = flavor;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
        this.schemaColumns = schema.getColumns();
    }

    public void setColumnFactory(ColumnFactory columnFactory) {
        this.columnFactory = columnFactory;
    }

    public WriteSupport.WriteContext init(Configuration entries) {
        this.columns = new ArrayList<Column>();
        for (SchemaColumn sc : this.schema.getColumns()) {
            this.columns.add(this.columnFactory.column(sc.getName()));
        }
        this.mt = new ParquetSchemaBuilder(this.lowerCaseIdentifiers, this.flavor).dssSchemaToParquet(this.schemaColumns);
        logger.info((Object)("Output Parquet MessageType : \n" + this.mt.toString()));
        return new WriteSupport.WriteContext(this.mt, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(ReusableParquetRow row) {
        row.replay(this.recordConsumer);
    }
}

