/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.formats.BinaryHeader;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.utils.PathUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ParquetFormatDetector {
    private static final byte[] PARQUET_MAGIC = "PAR1".getBytes(StandardCharsets.US_ASCII);

    public List<InputFormatsDetector.FormatWithMetadata> detect(Dataset dataset, FSDatasetUtils.PathsBasedSplit split) {
        ArrayList<InputFormatsDetector.FormatWithMetadata> fwms = new ArrayList<InputFormatsDetector.FormatWithMetadata>();
        if (DatasetInspector.isMetastoreAssociatedType(dataset)) {
            List<FSPath> paths = split.getPaths();
            String singlePath = dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).path;
            boolean singleParquet = singlePath != null && singlePath.toLowerCase(Locale.ENGLISH).endsWith(".parquet");
            boolean allParquet = false;
            if (paths.size() > 0) {
                allParquet = true;
                for (FSPath splitPath : paths) {
                    if (PathUtils.makeLeadingNoTrailing((String)splitPath.path()).toLowerCase(Locale.ENGLISH).endsWith(".parquet")) continue;
                    allParquet = false;
                }
            }
            if (allParquet || singleParquet) {
                InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
                fwm.detectionScore = 600.0;
                fwm.type = ParquetFormatMeta.META.getType();
                fwm.params = new ParquetFormatConfig();
                fwms.add(fwm);
            }
        }
        return fwms;
    }

    public Collection<? extends InputFormatsDetector.FormatWithMetadata> detect(BinaryHeader header) {
        if (header.bytes.length < PARQUET_MAGIC.length) {
            return Collections.emptyList();
        }
        if (Arrays.equals(PARQUET_MAGIC, Arrays.copyOfRange(header.bytes, 0, PARQUET_MAGIC.length))) {
            InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
            fwm.detectionScore = 600.0;
            fwm.params = new ParquetFormatConfig();
            fwm.type = ParquetFormatMeta.META.getType();
            fwm.metadata = new HashMap<String, String>();
            return Arrays.asList(fwm);
        }
        return Collections.emptyList();
    }
}

