/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.utils;

import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.partitioning.Partition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.ArchiveInputStream;

public class ByteArrayEnrichedStream
implements EnrichedInputStream {
    private byte[] data;
    private Map<String, String> metas = new HashMap<String, String>();
    private Partition partition;

    public ByteArrayEnrichedStream(byte[] data) {
        this.data = data;
    }

    public String desc() {
        return "ByteArray";
    }

    public String getFilename() {
        return null;
    }

    public String getPathWithinProvider() {
        return null;
    }

    @Nonnull
    public LongSupplier getLastModifiedSupplier() {
        return () -> 0L;
    }

    public boolean repeatable() {
        return true;
    }

    public ByteArrayEnrichedStream withMeta(String k, String v) {
        this.metas.put(k, v);
        return this;
    }

    public Map<String, String> metas() {
        return this.metas;
    }

    public InputStream decompressedStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public InputStream rawStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public long size() {
        return this.data.length;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public InputStream decompressedHeadStream(long targetSize) throws IOException {
        return this.decompressedStream();
    }

    public EnrichedInputStream.Compression getCompression() {
        return EnrichedInputStream.Compression.NONE;
    }

    public boolean isArchive() {
        return false;
    }

    public ArchiveInputStream archiveContent() {
        throw new IllegalStateException();
    }

    public InputStream rawHeadStream(long targetSize) throws IOException {
        return this.rawStream();
    }
}

