/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.integrations.AbstractIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.security.DefaultRedirectStrategyWithIPBlacklist;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.BasicClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpConnectionParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractHttpIntegrationEventHandler
extends AbstractIntegrationEventHandler {
    protected static final String NO_AUTH = null;

    protected RequestResponse postJsonRequest(String url, boolean useProxy, String json, @Nullable String authorization) throws IOException {
        return this.postJsonRequest(URI.create(url), useProxy, json, authorization);
    }

    protected RequestResponse postJsonRequest(URI uri, boolean useProxy, String json, @Nullable String authorization) throws IOException {
        HttpPost request = new HttpPost(uri);
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        if (authorization != null) {
            request.setHeader("Authorization", authorization);
        }
        return this.sendRequest(request, useProxy);
    }

    protected RequestResponse postRequest(String url, boolean useProxy, List<NameValuePair> postParameters, @Nullable String authorization) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, StandardCharsets.UTF_8));
        if (authorization != null) {
            request.setHeader("Authorization", authorization);
        }
        return this.sendRequest(request, useProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestResponse sendRequest(HttpPost request, boolean useProxy) throws IOException {
        ProxySettings proxySettings = new ProxySettings();
        if (useProxy) {
            proxySettings = ApplicationConfigurator.getProxySettings();
        }
        IPBlacklistVerifier.validateUriNotBlacklisted(request.getURI().toString(), proxySettings);
        DefaultRedirectStrategyWithIPBlacklist redirectStrategy = new DefaultRedirectStrategyWithIPBlacklist(proxySettings);
        HttpParams httpParams = request.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
        try (AutoCloseableClient client = this.getClient(useProxy, (RedirectStrategy)redirectStrategy);){
            RequestResponse requestResponse;
            block11: {
                HttpResponse response = null;
                try {
                    response = client.execute((HttpUriRequest)request);
                    int statusCode = response.getStatusLine().getStatusCode();
                    String statusReason = response.getStatusLine().getReasonPhrase();
                    requestResponse = new RequestResponse(statusCode, statusReason, AbstractHttpIntegrationEventHandler.getResponseAsText(response));
                    if (response == null) break block11;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    }
                    throw throwable;
                }
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            return requestResponse;
        }
    }

    protected AutoCloseableClient getClient(boolean useProxy, RedirectStrategy redirectStrategy) {
        BasicClientConnectionManager connectionManager = new BasicClientConnectionManager();
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        if (useProxy) {
            ProxyUtils.applyProxySettings((ProxySettings)ApplicationConfigurator.getProxySettings(), (DefaultHttpClient)client);
        }
        if (redirectStrategy != null) {
            client.setRedirectStrategy(redirectStrategy);
        }
        return new AutoCloseableClient(connectionManager, client);
    }

    protected static String basicAccessAuthHeader(String id, String password) {
        return "Basic " + Base64.encodeBase64String((byte[])(id + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    protected static String getResponseAsText(HttpResponse response) throws IOException {
        return response.getEntity() != null ? IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8) : "";
    }

    protected static class RequestResponse
    extends Exception {
        public final int statusCode;
        public final String statusReason;
        public final String content;

        public RequestResponse(int statusCode, String statusReason, String content) {
            this.statusCode = statusCode;
            this.statusReason = statusReason;
            this.content = content;
        }

        public boolean isSuccess() {
            return this.statusCode == 200 || this.statusCode == 202;
        }
    }

    protected static class AutoCloseableClient
    implements AutoCloseable {
        private final BasicClientConnectionManager connectionManager;
        private final DefaultHttpClient client;

        AutoCloseableClient(BasicClientConnectionManager connectionManager, DefaultHttpClient client) {
            this.connectionManager = connectionManager;
            client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
            this.client = client;
        }

        public HttpResponse execute(HttpUriRequest req) throws IOException {
            return this.client.execute(req);
        }

        @Override
        public void close() {
            this.connectionManager.shutdown();
        }
    }

    public static class HTTPChannelConfiguration
    implements IntegrationChannelParams {
        public boolean useProxy = true;
    }
}

