/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.io.BinaryStreamEncoder;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.ColumnBlockWriter;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.utils.JSON;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.log4j.Logger;

public class LinoWriter {
    public static final String GEO_LONGITUDE_SUFFIX = "__dku_lon";
    public static final String GEO_LATITUDE_SUFFIX = "__dku_lat";
    public static final String GEO_RAW_SUFFIX = "__dku_raw";
    private final File folder;
    private final String name;
    private final int blockSize;
    private boolean columnFellBackInCurrentRow;
    private int writtenInCurBlock;
    private int totalWritten;
    private final LinoMetaFile meta = new LinoMetaFile();
    private OutputStream os;
    BinaryStreamEncoder streamEncoder;
    public static final int DEFAULT_BLOCK_SIZE = 50000;
    private static final Logger logger = Logger.getLogger((String)"dku.lino");

    public LinoWriter(File folder, String name) {
        this(folder, name, 50000);
    }

    public LinoWriter(File folder, String name, int blockSize) {
        this.folder = folder;
        this.name = name;
        this.blockSize = blockSize;
    }

    public void addColumn(String name, ColumnBlock.MemoryType memType) {
        this.addColumn(name, memType, null);
    }

    public void addColumn(String name, ColumnBlock.MemoryType memType, Type realType) {
        LinoMetaFile.ColumnHeader colHeader = new LinoMetaFile.ColumnHeader();
        colHeader.name = name;
        colHeader.memType = memType;
        colHeader.realType = realType;
        colHeader.curWriter = new ColumnBlockWriter(colHeader.memType, this.blockSize);
        if (memType == ColumnBlock.MemoryType.STRING_DICT) {
            colHeader.stringReverse.put("___dku_no_value___", 0);
            colHeader.stringForward.add("___dku_no_value___");
            colHeader.curWriter.stringReverse = colHeader.stringReverse;
            colHeader.curWriter.stringForward = colHeader.stringForward;
        }
        logger.info((Object)("  Add col " + name + "  " + String.valueOf((Object)memType) + " idx " + this.meta.cols.size()));
        this.meta.cols.add(colHeader);
    }

    public void init() throws IOException {
        this.os = new BufferedOutputStream(Files.newOutputStream(new File(this.folder, this.name + ".data").toPath(), new OpenOption[0]));
        this.streamEncoder = new BinaryStreamEncoder(this.os);
    }

    public void beginRow() {
        this.columnFellBackInCurrentRow = false;
    }

    public void write(int col, double val) {
        this.meta.cols.get((int)col).curWriter.append(val);
    }

    public void write(int col, int val) {
        this.meta.cols.get((int)col).curWriter.append(val);
    }

    public void write(int col, String val) throws IOException {
        LinoMetaFile.ColumnHeader columnHeader = this.meta.cols.get(col);
        if (columnHeader.memType == ColumnBlock.MemoryType.STRING || columnHeader.fellBack) {
            columnHeader.curWriter.append(val);
        } else if (columnHeader.memType == ColumnBlock.MemoryType.STRING_DICT) {
            columnHeader.curWriter.appendForDict(val);
        } else {
            logger.error((Object)("Illegal write in column " + col + " of type " + String.valueOf((Object)columnHeader.memType)));
            assert (false);
        }
        if (columnHeader.shouldFallBack()) {
            columnHeader.fellBack = true;
            this.columnFellBackInCurrentRow = true;
            logger.warn((Object)String.format("Falling back column %s to %s encoding", new Object[]{columnHeader.name, ColumnBlock.MemoryType.STRING}));
        }
    }

    public void endRow() throws IOException {
        ++this.writtenInCurBlock;
        ++this.totalWritten;
        if (this.writtenInCurBlock == this.blockSize || this.columnFellBackInCurrentRow) {
            for (LinoMetaFile.ColumnHeader col : this.meta.cols) {
                long offset = this.streamEncoder.getWritten();
                col.offsetsList.add(offset);
                col.curWriter.flush(this.streamEncoder);
                col.curWriter = new ColumnBlockWriter(col.fellBack ? ColumnBlock.MemoryType.STRING : col.memType, this.blockSize);
                if (col.memType != ColumnBlock.MemoryType.STRING_DICT) continue;
                col.curWriter.stringReverse = col.stringReverse;
                col.curWriter.stringForward = col.stringForward;
            }
            System.err.println("End of block at " + this.streamEncoder.getWritten() + " written " + this.totalWritten + " records");
            this.meta.blockIndexList.add((long)this.totalWritten);
            this.writtenInCurBlock = 0;
        }
    }

    public void end() throws IOException {
        for (LinoMetaFile.ColumnHeader col : this.meta.cols) {
            if (this.writtenInCurBlock > 0) {
                long offset = this.streamEncoder.getWritten();
                col.offsetsList.add(offset);
                col.curWriter.flush(this.streamEncoder);
            }
            col.offsets = col.offsetsList.getValidDataCopy();
            if (col.memType == ColumnBlock.MemoryType.STRING_DICT) {
                col.stringDict = col.stringForward;
                logger.info((Object)String.format("Lino end : %s stringdict=%d offsets=%d%s", col.name, col.stringDict.size(), col.offsets.length, col.fellBack ? " (fellback)" : ""));
                continue;
            }
            logger.info((Object)("Lino end : " + col.name + " offsets=" + col.offsets.length));
        }
        if (this.writtenInCurBlock > 0) {
            this.meta.blockIndexList.add((long)this.totalWritten);
        }
        this.meta.blockIndex = this.meta.blockIndexList.getValidDataCopy();
        this.meta.nbRecords = this.totalWritten;
        this.os.close();
        JSON.prettyToFile((Object)this.meta, (File)new File(this.folder, this.name + ".meta.json"));
    }
}

