/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.labeling.LabelsDatasetHandler;
import com.dataiku.dip.datasets.labeling.LabelsDatasetParams;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.labeling.ImageViewSettings;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTaskCheck;
import com.dataiku.dip.labeling.LabelingTaskStats;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.labeling.TextLabelingTask;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelingTasksCRUDService {
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private LabelingInternalDBService labelingInternalDBService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LabelingService labelingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.labelingTasksCRUD");

    public List<LabelingTask> listAccessibleUnsafe(AuthCtx u, String projectKey) throws Exception {
        ArrayList<LabelingTask> ret = new ArrayList<LabelingTask>();
        for (LabelingTask task : this.listAllUnsafe(projectKey)) {
            if (!this.permissionsService.hasLabelingTaskPrivilege(u, task, Privileges.LabelingLevelPrivilegeType.READ)) continue;
            ret.add(task);
        }
        return ret;
    }

    public List<LabelingTask> listAllUnsafe(String projectKey) throws IOException {
        return this.labelingTasksDAO.listUnsafe(projectKey);
    }

    public void rename(String projectKey, String labelingTaskId, String newName) throws Exception {
        LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
        labelingTask.name = newName;
        this.upsertLabelingTask(labelingTask, null);
    }

    public void delete(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getOrNull(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, labelingTask);
        TaggableObjectsDeletionService.DeletionImpact di = this.computeDeletionImpact(authCtx, projectKey, id, ignored);
        for (TaggableObjectsDeletionService.ImpactedDataset impactedDataset : di.deletedDatasets) {
            this.datasetDeletionService.performDeletion(this.datasetAccessService.getMandatory(impactedDataset.projectKey, impactedDataset.name), ignored, authCtx, false);
            this.datasetSaveService.delete(impactedDataset.projectKey, impactedDataset.name);
        }
        JsonObject details = new JsonObject();
        if (labelingTask != null) {
            this.flowZonesService.cleanupObjectFromZones(projectKey, labelingTask);
            details.addProperty("objectDisplayName", labelingTask.name);
        }
        this.labelingTasksDAO.delete(projectKey, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.LABELING_TASK, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.LABELING_TASK_DELETE).withDetails(details));
    }

    public void attachLabelingTaskToZone(LabelingTask labelingTask, String zoneId) throws IOException {
        if (StringUtils.isNotBlank((String)zoneId)) {
            this.flowZonesService.attachObjectToZone(zoneId, labelingTask.projectKey, labelingTask, true);
        } else {
            zoneId = this.flowZonesService.retrieveInputZone(labelingTask);
            this.flowZonesService.attachObjectToZone(zoneId, labelingTask.projectKey, labelingTask);
            List<LabelingTask.LabelingTaskOutput> outputs = labelingTask.getFlatOutputs();
            for (LabelingTask.LabelingTaskOutput output : outputs) {
                Dataset labelsDataset = this.datasetAccessService.getOrNull(output.getLoc(labelingTask.projectKey));
                if (labelsDataset == null) continue;
                this.flowZonesService.attachObjectToZone(zoneId, labelingTask.projectKey, labelsDataset.getModel());
            }
        }
    }

    public LabelingTaskStats getStats_NT(AuthCtx authCtx, LabelingTask labelingTask, boolean includePerAnnotatorScore) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        LabelingTaskStats stats = new LabelingTaskStats();
        this.labelingInternalDBService.fillPerAnswerStats(authCtx, labelingTask, metadataDataset, stats, includePerAnnotatorScore);
        this.labelingInternalDBService.fillPerRecordStatusGlobalStats(authCtx, labelingTask, metadataDataset, stats);
        return stats;
    }

    public void check_NT(AuthCtx authCtx, LabelingTask labelingTask) throws Exception {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        LabelingTaskCheck labelingTaskCheck = this.labelingInternalDBService.checkLabelingTask(authCtx, labelingTask, metadataDataset);
        if (labelingTaskCheck.invalidPrelabelsCount > 0L) {
            String errorMessage = "Failed to import prelabels for " + labelingTaskCheck.invalidPrelabelsCount + " record(s). Make sure the column '" + labelingTask.preLabelColumn + "' contains valid labels.";
            if (labelingTaskCheck.invalidPrelabelError != null) {
                errorMessage = errorMessage + " First error: " + labelingTaskCheck.invalidPrelabelError;
            }
            throw new IllegalConfigurationException(errorMessage);
        }
    }

    public LabelingTask upsertLabelingTask(LabelingTask labelingTask, @Nullable String zoneId) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)labelingTask.projectKey);
        Preconditions.checkNotNull((Object)labelingTask.name);
        Preconditions.checkNotNull((Object)((Object)labelingTask.type));
        LabelingTask taskToSave = (LabelingTask)JSON.deepCopy((Object)labelingTask);
        LabelingTask preExisting = null;
        if (taskToSave.id != null) {
            preExisting = (LabelingTask)this.labelingTasksDAO.getMandatory(labelingTask.projectKey, taskToSave.id);
        }
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(taskToSave, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", taskToSave.name);
        if (preExisting == null) {
            taskToSave.creationTag = new VersionTag(t.getUser().getIdentifier());
            taskToSave.id = SecretKeyGenerator.generate((int)10);
            taskToSave.owner = t.getUser().getIdentifier();
            taskToSave.labelColumnName = LabelingTask.getDefaultLabelColumnName(labelingTask.type);
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(taskToSave);
            this.attachLabelingTaskToZone(taskToSave, zoneId);
            action = TaggableObjectChangedEvent.ActionType.LABELING_TASK_CREATE;
        } else if (!taskToSave.name.equals(preExisting.name)) {
            action = TaggableObjectChangedEvent.ActionType.LABELING_TASK_RENAME;
            details.addProperty("newName", taskToSave.name);
            details.addProperty("oldName", preExisting.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.LABELING_TASK_EDIT;
            diff = this.colaborativeMetadataDiffService.diff(preExisting, taskToSave, t.getUser().getIdentifier());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), preExisting, taskToSave);
        if (action.equals((Object)TaggableObjectChangedEvent.ActionType.LABELING_TASK_CREATE)) {
            logger.infoV("Saving new labeling task %s", new Object[]{taskToSave.id});
        } else {
            logger.infoV("Updating labeling task %s", new Object[]{taskToSave.id});
        }
        this.labelingTasksDAO.save(taskToSave);
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        } else {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.LABELING_TASK, taskToSave.projectKey, taskToSave.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(taskToSave.projectKey, taskToSave.tags);
        if (action == TaggableObjectChangedEvent.ActionType.LABELING_TASK_RENAME) {
            this.graphService.invalidateCache();
        }
        this.updateOutputLabelsDataset(taskToSave);
        this.onPostLabelingTaskSave(preExisting, taskToSave);
        return taskToSave;
    }

    private void onPostLabelingTaskSave(LabelingTask before, LabelingTask after) throws IOException {
        if (before == null || after == null) {
            return;
        }
        if (LabelingTasksCRUDService.shouldInvalidateMetadata(before, after)) {
            logger.info((Object)("Invalidating metadata cache of task id=" + after.id));
            this.invalidateMetadataTableCache(after);
        }
    }

    private static boolean shouldInvalidateMetadata(LabelingTask before, LabelingTask after) {
        if (!StringUtils.equals((String)before.idColumn, (String)after.idColumn)) {
            logger.info((Object)("Id column of task id=" + after.id + " changed, must invalidate metadata cache"));
            return true;
        }
        if (before instanceof TextLabelingTask && after instanceof TextLabelingTask && !StringUtils.equals((String)((TextLabelingTask)before).dataColumn, (String)((TextLabelingTask)after).dataColumn)) {
            logger.info((Object)("Text column of task id=" + after.id + " changed, must invalidate metadata cache"));
            return true;
        }
        if (!Arrays.equals(before.extraColumns.toArray(), after.extraColumns.toArray())) {
            logger.info((Object)("Extra columns for task id=" + after.id + " changed, must invalidate metadata cache"));
            return true;
        }
        if (!StringUtils.equals((String)before.preLabelColumn, (String)after.preLabelColumn)) {
            logger.info((Object)("Prelabel column of task id=" + after.id + " changed, must invalidate metadata cache"));
            return true;
        }
        return false;
    }

    private void updateOutputLabelsDataset(LabelingTask labelingTask) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        for (LabelingTask.LabelingTaskOutput output : labelingTask.getFlatOutputs()) {
            Dataset dataset = this.datasetAccessService.getOrNull(labelingTask.projectKey, output.ref);
            if (dataset == null || !dataset.getType().equals("Labels")) continue;
            LabelsDatasetParams params = dataset.getParamsAs(LabelsDatasetParams.class);
            params.labelingTaskId = labelingTask.id;
            params.labelingTaskType = labelingTask.type;
            dataset.setParams(params);
            Schema newSchema = LabelsDatasetHandler.getSchema(params, labelingTask);
            Schema oldSchema = dataset.getSchema();
            if (!newSchema.equals(oldSchema)) {
                logger.info((Object)("Updating schema of labels dataset " + dataset.getFullName()));
                dataset.setSchema(newSchema);
            }
            SerializedDataset sds = dataset.serialize();
            if (labelingTask.type.dataType == LabelingTask.LabelingDataType.IMAGE) {
                sds.imageViewSettings = this.getImageViewSettings(labelingTask);
            }
            logger.info((Object)("Connecting labels dataset: " + dataset.getFullName() + " to labeling task:" + labelingTask.id));
            this.datasetSaveService.save(dataset.getProjectKey(), dataset.getName(), sds, t.getUser());
        }
    }

    private ImageViewSettings getImageViewSettings(LabelingTask labelingTask) {
        ImageViewSettings ret = new ImageViewSettings();
        ret.defaultViewOnExplore = true;
        ret.enabled = true;
        ret.managedFolderSmartId = labelingTask.getManagedFolderLoc().getSmartName(labelingTask.projectKey);
        ret.annotationParams.enabled = true;
        ret.annotationParams.annotationCategories = labelingTask.classes.stream().map(c2 -> c2.key).collect(Collectors.toList());
        ret.annotationParams.annotationType = labelingTask.type.annotationType;
        ret.annotationParams.annotationColumn = labelingTask.labelColumnName;
        ret.pathColumn = labelingTask.idColumn;
        return ret;
    }

    private void addOutputDatasetsToDeletionImpact(AuthCtx authCtx, List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowDataset)) continue;
                FlowDataset fd = (FlowDataset)graphNode;
                SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                if (ignored != null && ignored.contains(new TaggableObjectsService.TaggableObjectRef(sds.getProjectKey(), ITaggingService.TaggableType.DATASET, sds.name))) continue;
                di.deletedDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                di.merge(this.datasetDeletionService.computeDeletionImpact(authCtx, Dataset.fromSerialized(sds), ignored, false));
            }
            catch (Exception e) {
                logger.info((Object)"Failed to compute dataset deletion impact: ", (Throwable)e);
            }
        }
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws IOException {
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        ProjectFlowGraph graphUnsafe = this.graphService.getProjectGraphUnsafe(projectKey);
        FlowLabelingTask fltUnsafe = graphUnsafe.getLabelingTask(projectKey, id);
        if (fltUnsafe != null) {
            this.addOutputDatasetsToDeletionImpact(authCtx, fltUnsafe.getSuccessors(), di, ignored);
        }
        TaggableObjectsDeletionService.AvailableDeletionOptions availableOptions = new TaggableObjectsDeletionService.AvailableDeletionOptions();
        availableOptions.shouldGiveOptionToDropData = true;
        availableOptions.isDropDataDangerous = false;
        di.availableOptions.put(projectKey + "." + id, availableOptions);
        return di;
    }

    public void clearLabelingTaskForDeletion(LabelingTask labelingTask) throws SQLException {
        logger.info((Object)("Pre-deletion cleanup of labeling " + labelingTask.getDisplayName()));
        this.labelingInternalDBService.dropLabelingAnswers(labelingTask.projectKey, labelingTask.id);
    }

    public void dropMetadataTable(LabelingTask labelingTask) throws Exception {
        if (!labelingTask.hasInputMetadataDataset()) {
            logger.warn((Object)"No metadata dataset to be dropped");
            return;
        }
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        this.labelingInternalDBService.dropMetadataTable(labelingTask, metadataDataset);
    }

    public void deleteLabelingTaskReference(Dataset dataset) throws Exception {
        if (dataset.getType().equals("Labels")) {
            LabelingTask labelingTask;
            LabelsDatasetParams params = dataset.getParamsAs(LabelsDatasetParams.class);
            if (params.labelingTaskId != null && (labelingTask = (LabelingTask)this.labelingTasksDAO.getOrNull(dataset.getProjectKey(), params.labelingTaskId)) != null) {
                logger.info((Object)("Removing reference of labels dataset: " + dataset.getFullName() + " in labeling task:" + labelingTask.id));
                labelingTask.clearOutput("main", dataset.getName());
                this.upsertLabelingTask(labelingTask, null);
            }
        }
    }

    public void copyLabelingAnswers(AuthCtx authCtx, LabelingTask original, LabelingTask copy) throws Exception {
        logger.info((Object)("Copying labeling answers form labeling task: " + original.id + " to labeling task: " + copy.id));
        this.labelingInternalDBService.copyLabelingAnswers(authCtx, original, copy);
    }

    public void invalidateMetadataTableCache(LabelingTask labelingTask) throws IOException {
        Dataset metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
        this.labelingInternalDBService.invalidateMetadataTableCache(labelingTask, metadataDataset);
    }
}

