/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.custom;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.recipes.nlp.common.LLMCompletionSettings;
import java.util.List;
import java.util.stream.Collectors;

public class CustomLLMClientAdapter {
    public static LLMClient.CompletionQuery toLegacyFormat(LLMClient.SingleCompletionQuery scq, LLMClient.CompletionSettings settings) {
        if (scq == null) {
            return null;
        }
        LLMClient.CompletionQuery cq = new LLMClient.CompletionQuery();
        cq.messages = scq.messages;
        cq.settings = new LLMCompletionSettings();
        cq.settings.topP = settings.topP;
        cq.settings.topK = settings.topK;
        cq.settings.temperature = settings.temperature;
        cq.settings.maxOutputTokens = settings.maxOutputTokens;
        cq.settings.stopSequences = settings.stopSequences;
        cq.settings.frequencyPenalty = settings.frequencyPenalty;
        cq.settings.presencePenalty = settings.presencePenalty;
        cq.settings.logitBias = settings.logitBias;
        cq.settings.logProbs = settings.logProbs;
        cq.settings.topLogProbs = settings.topLogProbs;
        if (settings.responseFormat != null) {
            cq.settings.responseFormat = settings.responseFormat.toLegacyResponseFormat();
        }
        cq.settings.toolChoice = settings.toolChoice;
        cq.settings.tools = settings.tools;
        cq.settings.outputTrajectory = settings.outputTrajectory;
        cq.classLabels = settings.classLabels;
        cq.hypothesisTemplate = settings.hypothesisTemplate;
        cq.summarizationMinTokens = settings.summarizationMinTokens;
        cq.summarizationMaxTokens = settings.summarizationMaxTokens;
        cq.summarizationSpecialTokensSafetyFactor = settings.summarizationSpecialTokensSafetyFactor;
        cq.summarizationNumOverlapTokens = settings.summarizationNumOverlapTokens;
        cq.summarizationMaxNumSplitLevels = settings.summarizationMaxNumSplitLevels;
        if (settings.textClassificationOutputMode != null) {
            switch (settings.textClassificationOutputMode) {
                case ALL: {
                    cq.textClassificationOutputMode = LLMClient.CompletionQuery.ClassificationOutputMode.ALL;
                    break;
                }
                case MOST_RELEVANT: {
                    cq.textClassificationOutputMode = LLMClient.CompletionQuery.ClassificationOutputMode.MOST_RELEVANT;
                    break;
                }
                case FIRST: {
                    cq.textClassificationOutputMode = LLMClient.CompletionQuery.ClassificationOutputMode.FIRST;
                }
            }
        }
        return cq;
    }

    public static List<LLMClient.CompletionQuery> toLegacyFormat(List<LLMClient.SingleCompletionQuery> queries, LLMClient.CompletionSettings settings) {
        if (queries == null) {
            return null;
        }
        List<LLMClient.CompletionQuery> legacyQueries = queries.stream().map(scq -> CustomLLMClientAdapter.toLegacyFormat(scq, settings)).collect(Collectors.toList());
        return legacyQueries;
    }
}

