/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.governance;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GuardrailsBypassTokensService {
    private final Set<String> activeBypassTokens = new HashSet<String>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.guardrails.tokens");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newBypassToken() {
        String token = SecretKeyGenerator.generate();
        GuardrailsBypassTokensService guardrailsBypassTokensService = this;
        synchronized (guardrailsBypassTokensService) {
            this.activeBypassTokens.add(token);
        }
        return token;
    }

    public synchronized void invalidateBypassToken(String token) {
        assert (this.activeBypassTokens.contains(token));
        this.activeBypassTokens.remove(token);
    }

    public synchronized boolean hasValidBypassToken(HttpServletRequest req) throws DKUSecurityException {
        String tokenInRequest = req.getHeader("x-dku-guardrails-bypass-token");
        if (StringUtils.isBlank((String)tokenInRequest)) {
            return false;
        }
        boolean has = this.activeBypassTokens.contains(tokenInRequest);
        if (!has) {
            throw new DKUSecurityException("Invalid bypass token used, rejecting request");
        }
        logger.debug((Object)"Request has a bypass token");
        return true;
    }
}

