/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.governance.custom;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.llm.governance.GuardrailsRegistry;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailDesc;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailMeta;
import com.dataiku.dip.llm.governance.custom.LoadedCustomGuardrail;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class CustomGuardrailsService
extends AbstractElementService<CustomGuardrailDesc, LoadedCustomGuardrail> {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.llm.guardrails.custom");

    @Override
    public String getFolderName() {
        return "python-guardrails";
    }

    @Override
    public String getPrefix() {
        return "guardrail";
    }

    @Override
    protected String getCodeExtension(LoadedCustomGuardrail desc) {
        return "";
    }

    @Override
    public Class<CustomGuardrailDesc> getDescClass() {
        return CustomGuardrailDesc.class;
    }

    @Override
    public Class<LoadedCustomGuardrail> getLoadedDescClass() {
        return LoadedCustomGuardrail.class;
    }

    @Override
    protected void removeElement(LoadedCustomGuardrail desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "guardrail_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedCustomGuardrail load(String elementType, String pluginId, String elementId, File file) throws IOException {
        CustomGuardrailDesc desc = (CustomGuardrailDesc)JSON.parseFile((File)file, CustomGuardrailDesc.class);
        desc.id = elementType;
        LoadedCustomGuardrail loaded = new LoadedCustomGuardrail(elementType, pluginId, elementId, desc);
        CustomGuardrailMeta stepMeta = new CustomGuardrailMeta(loaded);
        GuardrailsRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomGuardrailDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomGuardrailsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }

    public String getPythonLibFolder(String elementType) {
        if (!this.loadedDescs.containsKey(elementType)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "Element " + elementType + " not found.");
        }
        LoadedCustomGuardrail loadedDesc = (LoadedCustomGuardrail)this.loadedDescs.get(elementType);
        File libDir = this.pluginsService.getPluginPythonlibFolder(loadedDesc.getOwnerPluginId());
        return libDir.getAbsolutePath();
    }
}

