/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.local;

import com.dataiku.dip.analysis.ml.hf.IModelCacheDownloadService;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.KernelErrorCodes;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.llm.local.HuggingFaceKernelClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.Map;

public class HuggingFaceKernelBuilder {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.huggingface.kernel");

    private SimplePythonKernel instantiateKernel(AuthCtx authCtx, String clusterId, String projectKey, String codeEnvName, String containerConfName, String kernelId, Map<String, String> extraEnv) throws IOException, DKUSecurityException, CodedException {
        ContainerExecRuntimeConfig containerConfig = null;
        if (containerConfName != null) {
            if (clusterId == null) {
                clusterId = new ClusterSelector().getBuiltinOrDefaultClusterId(Cluster.ClusterArchitecture.KUBERNETES);
            }
            containerConfig = new ClusterSelector().selectForCluster(authCtx, "__builtin__", clusterId).getContainerSettings().getByName(containerConfName);
        }
        if (projectKey == null) {
            projectKey = "__DKU_ANY_PROJECT__";
        }
        return SimplePythonKernelFactory.prepareKernel(authCtx, projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, codeEnvName, "dataiku.huggingface.server", false, false, null, containerConfig, kernelId, kernelId + "-", false, true, extraEnv, true);
    }

    /*
     * Unable to fully structure code
     */
    public SimplePythonKernel createKernel(AuthCtx authCtx, String projectKey, HuggingFaceKernelClient.KernelConfig kernelConfig, String kernelId) throws Exception {
        block24: {
            if (!kernelConfig.startCommand.useDSSModelCache || kernelConfig.startCommand.fakeLLMServer) break block24;
            HuggingFaceKernelBuilder.logger.info((Object)"Model cache enabled, downloading model if needed prior to starting kernel");
            modelCacheService = (IModelCacheDownloadService)SpringUtils.getBean(IModelCacheDownloadService.class);
            switch (1.$SwitchMap$com$dataiku$dip$llm$local$HuggingFaceKernelClient$ModelOrigin[kernelConfig.startCommand.modelOrigin.ordinal()]) {
                case 1: {
                    fp = FutureProgress.pushAutoCloseableState((String)"Downloading LLM model", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        modelCacheService.downloadModelIfNeeded_Check(kernelConfig.startCommand.hfModelName, authCtx, kernelConfig.hfConnectionName);
                        FutureProgress.updateState((double)1.0);
                    }
                    finally {
                        if (fp != null) {
                            fp.close();
                        }
                    }
                    modelPath = modelCacheService.getLocalModelPath(kernelConfig.startCommand.hfModelName);
                    baseModelKey = modelCacheService.getBaseModelKey(kernelConfig.startCommand.hfModelName);
                    baseModelPath = null;
                    if (baseModelKey != null) {
                        baseModelPath = modelCacheService.getLocalModelPath(baseModelKey);
                        HuggingFaceKernelBuilder.logger.info((Object)("Kernel will use model located in: " + modelPath + " and base model located in: " + baseModelPath));
                    } else {
                        HuggingFaceKernelBuilder.logger.info((Object)("Kernel will use model located in: " + modelPath));
                    }
                    kernelConfig.startCommand.setModelPath(modelPath, baseModelPath);
                    if (kernelConfig.startCommand.modelSettings == null || kernelConfig.startCommand.modelSettings.refinerId == null || kernelConfig.startCommand.modelSettings.refinerId.isBlank()) ** GOTO lbl35
                    fp = FutureProgress.pushAutoCloseableState((String)"Downloading Refiner model", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        modelCacheService.downloadModelIfNeeded_Check(kernelConfig.startCommand.modelSettings.refinerId, authCtx, kernelConfig.hfConnectionName);
                        FutureProgress.updateState((double)1.0);
                    }
                    finally {
                        if (fp != null) {
                            fp.close();
                        }
                    }
                    kernelConfig.startCommand.modelSettings.hfRefinerPath = modelCacheService.getLocalModelPath(kernelConfig.startCommand.modelSettings.refinerId);
                }
lbl35:
                // 3 sources

                case 2: {
                    if (kernelConfig.startCommand.baseModelName == null) ** GOTO lbl50
                    fp = FutureProgress.pushAutoCloseableState((String)"Downloading LLM model", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        modelCacheService.downloadModelIfNeeded_Check(kernelConfig.startCommand.baseModelName, authCtx, kernelConfig.hfConnectionName);
                        FutureProgress.updateState((double)1.0);
                    }
                    finally {
                        if (fp != null) {
                            fp.close();
                        }
                    }
                    baseModelPath = modelCacheService.getLocalModelPath(kernelConfig.startCommand.baseModelName);
                    HuggingFaceKernelBuilder.logger.info((Object)("Kernel will use saved model located in: " + kernelConfig.startCommand.savedModelVersionPath + " and base model located in " + baseModelPath));
                    kernelConfig.startCommand.baseModelPath = baseModelPath;
                    break;
lbl50:
                    // 1 sources

                    HuggingFaceKernelBuilder.logger.info((Object)("Kernel will use saved model located in: " + kernelConfig.startCommand.savedModelVersionPath));
                }
            }
        }
        kernel = this.instantiateKernel(authCtx, kernelConfig.clusterId, projectKey, kernelConfig.codeEnvName, kernelConfig.containerConfName, kernelId, kernelConfig.extraEnv);
        return kernel;
    }

    public void startKernel(SimplePythonKernel kernel, HuggingFaceKernelClient.KernelConfig kernelConfig) throws Exception {
        kernel.start();
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Initializing LLM model", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            FutureProgress.updateState((double)0.0);
            logger.info((Object)"Sending init request");
            kernel.getLink().getAsyncLink().request((Object)kernelConfig.startCommand, JsonElement.class);
            FutureProgress.updateState((double)1.0);
        }
        catch (Exception e) {
            kernel.close();
            throw new CodedException((InfoMessage.MessageCode)KernelErrorCodes.ERR_COMPUTE_KERNEL_FAILURE, "Local kernel failed to initialize model", (Throwable)e);
        }
    }
}

