/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.llm.LLMSavedModelInfo;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.openai.GenericOpenAIFineTuningClient;
import com.dataiku.dip.llm.online.openai.OpenAIClient;
import com.dataiku.dip.llm.online.openai.RawOpenAIClient;
import com.google.gson.JsonObject;

public class OpenAIFineTuningClient
extends GenericOpenAIFineTuningClient {
    private String getBaseModelVersionId(String baseModelId) {
        switch (baseModelId) {
            case "gpt-4o-mini": {
                return "gpt-4o-mini-2024-07-18";
            }
            case "gpt-4.1-mini": {
                return "gpt-4.1-mini-2025-04-14";
            }
            case "gpt-4.1-nano": {
                return "gpt-4.1-nano-2025-04-14";
            }
        }
        return baseModelId;
    }

    OpenAIFineTuningClient(OpenAIClient llmClient) {
        super(llmClient);
    }

    private OpenAIClient getLLMClient() {
        return (OpenAIClient)this.llmClient;
    }

    @Override
    protected RawOpenAIClient getRawClient() {
        return this.getLLMClient().getRaw();
    }

    @Override
    public boolean isChatModel() {
        return this.getLLMClient().getModel().isChatModel();
    }

    @Override
    public String getBaseModel() {
        return this.getBaseModelVersionId(this.getLLMClient().getModel().getId());
    }

    @Override
    public void enrichSavedModelPostFinetuning(String jobId, EnrichedLLMStructuredRef enrichedLLMRef, JsonObject fineTuningResponse, LLMSavedModelInfo llmSmi, FullModelId fmi) throws Exception {
        llmSmi.llmType = LLMStructuredRef.LLMType.SAVED_MODEL_FINETUNED_OPENAI;
        this.enrichSavedModel(jobId, enrichedLLMRef, fineTuningResponse, llmSmi, fmi);
    }
}

