/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.sagemakergeneric;

import com.dataiku.dip.llm.EnrichedLLMStructuredRef;

public enum GenericLLMHandling {
    AMAZON_NOVA("amazon.nova-", new EnrichedLLMStructuredRef.FieldRange(0.0, 500.0, 1.0)),
    AMAZON_TITAN("amazon.titan-text-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01)),
    AMAZON_TITAN_TEXT_EMBEDDING("amazon.titan-embed-text-"),
    AMAZON_TITAN_TEXT_IMAGE_EMBEDDING("amazon.titan-embed-image-"),
    ANTHROPIC_CLAUDE_CHAT("anthropic.claude-3-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01), new EnrichedLLMStructuredRef.FieldRange(0.0, 500.0, 1.0), true),
    ANTHROPIC_CLAUDE("anthropic.claude-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01), new EnrichedLLMStructuredRef.FieldRange(0.0, 500.0, 1.0)),
    AI21_J2("ai21.j2-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01)),
    AI21_SUMMARIZE,
    COHERE_COMMAND_CHAT("cohere.command-r-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01), new EnrichedLLMStructuredRef.FieldRange(0.0, 500.0, 1.0), true),
    COHERE_COMMAND("cohere.command-", new EnrichedLLMStructuredRef.FieldRange(0.0, 5.0, 0.05), new EnrichedLLMStructuredRef.FieldRange(0.0, 500.0, 1.0)),
    COHERE_EMBED("cohere.embed-"),
    HUGGING_FACE(null, new EnrichedLLMStructuredRef.FieldRange(0.0, 100.0, 0.1), new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0E8, 1.0)),
    META_LLAMA_2_BEDROCK("meta.llama2-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01)),
    META_LLAMA_3_BEDROCK("meta.llama3-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01)),
    META_LLAMA_2_SAGEMAKER(null, new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01)),
    STABILITYAI_STABLE_DIFFUSION_10("stability.stable-diffusion-xl-v1"),
    STABILITYAI_STABLE_IMAGE_CORE("stability.stable-image-core"),
    STABILITYAI_STABLE_DIFFUSION_3("stability.sd3"),
    STABILITYAI_STABLE_IMAGE_ULTRA("stability.stable-image-ultra"),
    MISTRAL_AI_CHAT("mistral.mistral-large-", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01), new EnrichedLLMStructuredRef.FieldRange(0.0, 200.0, 1.0), true),
    MISTRAL_AI("mistral.", new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01), new EnrichedLLMStructuredRef.FieldRange(0.0, 200.0, 1.0)),
    DEEPSEEK(null, new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01)),
    GENERIC_CONVERSE(null, new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01)),
    FULLY_CUSTOM(null, new EnrichedLLMStructuredRef.FieldRange(), new EnrichedLLMStructuredRef.FieldRange());

    public final String modelPrefix;
    public final EnrichedLLMStructuredRef.FieldRange temperatureRange;
    public final EnrichedLLMStructuredRef.FieldRange topKRange;
    public final boolean isChatModel;

    private GenericLLMHandling(String modelPrefix, EnrichedLLMStructuredRef.FieldRange temperatureRange, EnrichedLLMStructuredRef.FieldRange topKRange, boolean isChatModel) {
        this.modelPrefix = modelPrefix;
        this.temperatureRange = temperatureRange;
        this.topKRange = topKRange;
        this.isChatModel = isChatModel;
    }

    private GenericLLMHandling(String modelPrefix, EnrichedLLMStructuredRef.FieldRange temperatureRange, EnrichedLLMStructuredRef.FieldRange topKRange) {
        this(modelPrefix, temperatureRange, topKRange, false);
    }

    private GenericLLMHandling(String modelPrefix, EnrichedLLMStructuredRef.FieldRange temperatureRange) {
        this(modelPrefix, temperatureRange, null, false);
    }

    private GenericLLMHandling(String modelPrefix) {
        this(modelPrefix, null, null, false);
    }

    private GenericLLMHandling() {
        this(null, null, null, false);
    }
}

