/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.resourceusage.k8s.KubernetesClusterUsageGatherer;
import com.dataiku.dip.resourceusage.k8s.KubernetesClusterUsageStatus;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class ReportOnKubernetesClustersUsage
implements Job {
    @Autowired
    TransactionService transactionService;
    @Autowired
    ComputeResourceUsageReportingService reportingService;
    @Autowired
    ClustersDAO clustersDAO;
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    static DKULogger logger = DKULogger.getLogger((String)"dku.maint.tmp");

    public ReportOnKubernetesClustersUsage() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        DKULogger.startCurrentCall();
        try {
            ArrayList<String> clusters = new ArrayList<String>();
            GeneralSettingsDAO.GeneralSettings gs = null;
            try (Transaction t = this.transactionService.beginRead();){
                gs = this.generalSettingsDAO.getUnsafe();
                for (Cluster c2 : this.clustersDAO.listUnsafe()) {
                    if (c2.architecture != Cluster.ClusterArchitecture.KUBERNETES || c2.state != Cluster.ClusterState.RUNNING) continue;
                    clusters.add(c2.id);
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to list clusters", (Throwable)e);
            }
            for (String cluster : clusters) {
                ClusterSelection cs2 = new ClusterSelection();
                cs2.clusterId = cluster;
                cs2.clusterMode = ClusterSelection.ClusterMode.EXPLICIT_CLUSTER;
                try {
                    KubernetesClusterUsageStatus status = new KubernetesClusterUsageGatherer(cs2, gs.computeResourceUsageReportingSettings).getUsageStatus();
                    this.reportingService.reportK8SClusterStatus(status);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to report on Kubernetes cluster " + cluster + " usage"), (Throwable)e);
                }
            }
            if (gs.computeResourceUsageReportingSettings.includeBuiltinCluster) {
                ClusterSelection cs3 = new ClusterSelection();
                cs3.clusterMode = ClusterSelection.ClusterMode.INHERIT;
                try {
                    KubernetesClusterUsageStatus status = new KubernetesClusterUsageGatherer(cs3, gs.computeResourceUsageReportingSettings).getUsageStatus();
                    this.reportingService.reportK8SClusterStatus(status);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to report on global Kubernetes cluster usage", (Throwable)e);
                }
            }
        }
        finally {
            DKULogger.endCurrentCall();
        }
    }
}

