/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.meanings;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.meanings.SharedBasicMeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.MeaningChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeaningsService {
    @Autowired
    private MeaningsDAO dao;
    @Autowired
    private SharedBasicMeaningsService basicService;
    @Autowired
    private PubSubService pubSub;
    protected static Logger logger = Logger.getLogger((String)"dku.meanings.service");

    public void save(UserDefinedMeaning meaning) throws IOException {
        if (StringUtils.isBlank((String)meaning.label)) {
            throw new IllegalArgumentException("empty label");
        }
        if (meaning.type == null) {
            throw new IllegalArgumentException("empty type");
        }
        if (meaning.normalizationMode == null && meaning.type != UserDefinedMeaning.Type.DECLARATIVE) {
            meaning.normalizationMode = StringNormalizationMode.EXACT;
        }
        switch (meaning.type) {
            case VALUES_LIST: {
                if (meaning.entries == null) {
                    throw new IllegalArgumentException("User defined meaning entries should not be null");
                }
                if (DKUtils.listToMap(meaning.entries, (String)"value").size() >= meaning.entries.size()) break;
                throw new IllegalArgumentException("duplicate values");
            }
            case VALUES_MAPPING: {
                if (meaning.mappings == null) {
                    throw new IllegalArgumentException("User defined meaning mappings should not be null");
                }
                if (DKUtils.listToMap(meaning.mappings, (String)"from").size() >= meaning.mappings.size()) break;
                throw new IllegalArgumentException("duplicate mapping keys");
            }
            case PATTERN: {
                if (meaning.normalizationMode == StringNormalizationMode.NORMALIZED) {
                    throw new IllegalArgumentException("normalized mode is not available for type pattern");
                }
                if (StringUtils.isBlank((String)meaning.pattern)) {
                    throw new IllegalArgumentException("User defined meaning pattern should not be empty");
                }
                try {
                    Pattern.compile(meaning.pattern);
                    break;
                }
                catch (PatternSyntaxException ex) {
                    throw new IllegalArgumentException("invalid pattern: " + ExceptionUtils.getMessageWithCauses((Throwable)ex), ex);
                }
            }
        }
        this.dao.save(meaning);
        this.basicService.invalidateCache();
        this.pubSub.publishAfterTransaction((DSSEvent)new MeaningChangedEvent(meaning.id, meaning.label, MeaningChangedEvent.MeaningActionType.MEANING_EDIT));
    }

    public void create(UserDefinedMeaning meaning) throws IOException {
        meaning.id = meaning.id.toLowerCase();
        if (!Pattern.matches("^[a-z0-9_]+$", meaning.id)) {
            throw new IllegalArgumentException("id contains illegal characters");
        }
        for (UserDefinedMeaning udm : this.listUserDefinedUnsafe()) {
            if (!udm.id.equals(meaning.id)) continue;
            throw new IllegalArgumentException("id already exists");
        }
        this.save(meaning);
    }

    public void delete(String id) throws IOException {
        this.dao.delete(id);
        this.basicService.invalidateCache();
        this.pubSub.publishAfterTransaction((DSSEvent)new MeaningChangedEvent(id, null, MeaningChangedEvent.MeaningActionType.MEANING_DELETE));
    }

    public MeaningsList listAll() throws IOException {
        MeaningsList ret = new MeaningsList();
        ret.basic.add(new ShortMeaningInfo("Text", "Text"));
        ret.basic.add(new ShortMeaningInfo("DoubleMeaning", "Decimal"));
        ret.basic.add(new ShortMeaningInfo("LongMeaning", "Integer"));
        ret.basic.add(new ShortMeaningInfo("Boolean", "Boolean"));
        ret.basic.add(new ShortMeaningInfo("Date", "Datetime with tz"));
        ret.basic.add(new ShortMeaningInfo("DateOnly", "Date only"));
        ret.basic.add(new ShortMeaningInfo("DatetimeNoTz", "Datetime no tz"));
        ret.basic.add(new ShortMeaningInfo("JSONObjectMeaning", "Object"));
        ret.basic.add(new ShortMeaningInfo("JSONArrayMeaning", "Array"));
        ret.basic.add(new ShortMeaningInfo("FreeText", "Natural lang."));
        Category geo = new Category("Geospatial");
        geo.meanings.addAll(this.listGeoMeanings());
        ret.categories.add(geo);
        Category web = new Category("Web");
        web.meanings.add(new ShortMeaningInfo("IPAddress", "IP address"));
        web.meanings.add(new ShortMeaningInfo("QueryString", "HTTP Query string"));
        web.meanings.add(new ShortMeaningInfo("URL", "URL"));
        web.meanings.add(new ShortMeaningInfo("UserAgent", "User-Agent"));
        web.meanings.add(new ShortMeaningInfo("Email", "E-mail address"));
        ret.categories.add(web);
        Category other = new Category("Other");
        other.meanings.add(new ShortMeaningInfo("Temperature", "Temperature"));
        other.meanings.add(new ShortMeaningInfo("BagOfWordsMeaning", "Bag of words"));
        other.meanings.add(new ShortMeaningInfo("Gender", "Gender"));
        other.meanings.add(new ShortMeaningInfo("Measure", "Size/Weight"));
        other.meanings.add(new ShortMeaningInfo("CurrencyMeaning", "Currency code"));
        other.meanings.add(new ShortMeaningInfo("CurrencyAmountMeaning", "Money amount"));
        other.meanings.add(new ShortMeaningInfo("DateSource", "Date (unparsed)"));
        other.meanings.add(new ShortMeaningInfo("FrenchDoubleMeaning", "Decimal (comma)"));
        ret.categories.add(other);
        Category udc = new Category("User-defined");
        List<UserDefinedMeaning> userDefinedMeanings = this.listUserDefinedUnsafe();
        Collections.sort(userDefinedMeanings, new Comparator<UserDefinedMeaning>(){

            @Override
            public int compare(UserDefinedMeaning a, UserDefinedMeaning b) {
                String nameA = a.label == null ? a.id : a.label;
                String nameB = b.label == null ? b.id : b.label;
                return nameA.compareToIgnoreCase(nameB);
            }
        });
        for (UserDefinedMeaning udm : userDefinedMeanings) {
            udc.meanings.add(new ShortMeaningInfo(udm));
        }
        ret.categories.add(udc);
        for (Category c2 : ret.categories) {
            for (ShortMeaningInfo smi : c2.meanings) {
                ret.labelsMap.put(smi.id, smi.label);
            }
        }
        for (ShortMeaningInfo smi : ret.basic) {
            ret.labelsMap.put(smi.id, smi.label);
        }
        return ret;
    }

    public List<ShortMeaningInfo> listGeoMeanings() {
        return Arrays.asList(new ShortMeaningInfo("Latitude", "Latitude"), new ShortMeaningInfo("Longitude", "Longitude"), new ShortMeaningInfo("GeoPoint", "GeoPoint"), new ShortMeaningInfo("GeometryMeaning", "Geometry"), new ShortMeaningInfo("CountryMeaning", "Country"), new ShortMeaningInfo("USStateMeaning", "US State"));
    }

    public List<UserDefinedMeaning> listUserDefinedUnsafe() throws IOException {
        return this.dao.listUnsafe();
    }

    public UserDefinedMeaning getUnsafe(String id) throws IOException {
        for (UserDefinedMeaning meaning : this.dao.listUnsafe()) {
            if (!id.equals(meaning.id)) continue;
            return meaning;
        }
        throw ErrorContext.iaef((String)"Unknown meaning: %s", (Object)id, (Object[])new Object[0]);
    }

    public static class MeaningsList {
        public List<Category> categories = new ArrayList<Category>();
        public List<ShortMeaningInfo> basic = new ArrayList<ShortMeaningInfo>();
        public Map<String, String> labelsMap = new HashMap<String, String>();
    }

    public static class ShortMeaningInfo {
        public String id;
        public String label;
        public UserDefinedMeaning.Type type;

        ShortMeaningInfo(String id, String label) {
            this.id = id;
            this.label = label;
        }

        ShortMeaningInfo(UserDefinedMeaning udm) {
            this.id = udm.id;
            this.label = udm.label;
            this.type = udm.type;
        }
    }

    public static class Category {
        public String label;
        public List<ShortMeaningInfo> meanings = new ArrayList<ShortMeaningInfo>();

        Category(String label) {
            this.label = label;
        }
    }

    @Service
    public static class MeaningsDeletionService {
        @Autowired
        private IInternalDataCatalogService catalogService;

        public InfoMessage.InfoMessages prepareDelete(String meaningId) {
            long numColumns = 0L;
            try {
                this.catalogService.flush();
                numColumns = this.catalogService.columnsWithMeaning((String)meaningId, (AuthCtx)DSSAuthCtx.fakeAdminForTests((String)"dss-internal")).totalHits.value;
            }
            catch (Exception e) {
                logger.warn((Object)("Could not look for columns with forced meaning '" + meaningId + "' before its deletion."), (Throwable)e);
            }
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            if (numColumns > 0L) {
                messages.withWarning((InfoMessage.MessageCode)MeaningCodes.WARN_MEANING_DELETING_USED_UDM, "Meaning '" + meaningId + "' is still used by " + numColumns + " column" + (numColumns > 1L ? "s" : "") + ".");
            }
            return messages;
        }
    }

    public static enum MeaningCodes implements InfoMessage.MessageCode
    {
        WARN_MEANING_DELETING_USED_UDM("Meaning is still used", InfoMessage.FixabilityCategory.USER_CONFIG_DATASET);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private MeaningCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

