/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.drift;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.mec.drift.DriftParams;
import com.dataiku.dip.mec.drift.DriftResult;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.Params;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class DriftResultCachingService {
    private static final String CACHE_NAME = "dku.ml.mec.drift.results";
    public static final String MAX_SIZE_CONFIG_KEY = "dku.caches.dku.ml.mec.drift.results.maxSize";
    public static final String EXPIRATION_AFTER_ACCESS_MINUTES_CONFIG_KEY = "dku.caches.dku.ml.mec.drift.results.expireAfterAccessMn";
    private static final int RESULT_CACHE_DEFAULT_EXPIRATION_TIME_IN_MINUTES = 60;
    private static final int RESULT_CACHE_DEFAULT_MAX_SIZE = 50;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.ml.mec.drift");
    private final Cache<DriftResultCacheKey, DriftResult> cache;

    public DriftResultCachingService() {
        Params p = DKUApp.getParams();
        long maxSize = p.getLongParam(MAX_SIZE_CONFIG_KEY, 50L);
        long expireAfterAccessMn = p.getLongParam(EXPIRATION_AFTER_ACCESS_MINUTES_CONFIG_KEY, 60L);
        logger.infoV("Init computation results cache with maxSize %d and expireAfterAccessMn %d", new Object[]{maxSize, expireAfterAccessMn});
        this.cache = CacheBuilder.newBuilder().recordStats().maximumSize(maxSize).expireAfterAccess(expireAfterAccessMn, TimeUnit.MINUTES).build();
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)CACHE_NAME, this.cache));
    }

    public DriftResult get(DriftParams driftParams, String referenceMeLikeId, String currentModelLikeId, double referenceThreshold, double currentThreshold) {
        return (DriftResult)this.cache.getIfPresent((Object)new DriftResultCacheKey(driftParams, referenceMeLikeId, currentModelLikeId, referenceThreshold, currentThreshold));
    }

    public void put(DriftParams driftParams, String referenceMeLikeId, String currentModelLikeId, double referenceThreshold, double currentThreshold, DriftResult DriftResult2) {
        this.cache.put((Object)new DriftResultCacheKey(driftParams, referenceMeLikeId, currentModelLikeId, referenceThreshold, currentThreshold), (Object)DriftResult2);
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public static class DriftResultCacheKey {
        public DriftParams driftParams;
        public String referenceMeLikeId;
        public String currentModelLikeId;
        double referenceThreshold;
        double currentThreshold;

        public DriftResultCacheKey(DriftParams driftParams, String referenceMeLikeId, String currentModelLikeId, double referenceThreshold, double currentThreshold) {
            this.driftParams = driftParams;
            this.referenceMeLikeId = referenceMeLikeId;
            this.currentModelLikeId = currentModelLikeId;
            this.referenceThreshold = referenceThreshold;
            this.currentThreshold = currentThreshold;
        }

        public int hashCode() {
            return Objects.hash(this.driftParams, this.referenceMeLikeId, this.currentModelLikeId, this.referenceThreshold, this.currentThreshold);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DriftResultCacheKey that = (DriftResultCacheKey)o;
            return Double.compare(that.referenceThreshold, this.referenceThreshold) == 0 && Double.compare(that.currentThreshold, this.currentThreshold) == 0 && Objects.equals(this.driftParams, that.driftParams) && Objects.equals(this.referenceMeLikeId, that.referenceMeLikeId) && Objects.equals(this.currentModelLikeId, that.currentModelLikeId);
        }
    }
}

