/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.probes.AdvancedStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.BasicProbeType;
import com.dataiku.dip.metrics.probes.BasicStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.CellProbeType;
import com.dataiku.dip.metrics.probes.CheckProbeType;
import com.dataiku.dip.metrics.probes.CustomPythonProbeType;
import com.dataiku.dip.metrics.probes.CustomSQLProbeType;
import com.dataiku.dip.metrics.probes.ExternalProbeType;
import com.dataiku.dip.metrics.probes.LLMEvaluationProbeType;
import com.dataiku.dip.metrics.probes.ModelPerformanceProbeType;
import com.dataiku.dip.metrics.probes.PartitioningProbeType;
import com.dataiku.dip.metrics.probes.PercentileStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.PythonProbeType;
import com.dataiku.dip.metrics.probes.RecordsProbeType;
import com.dataiku.dip.metrics.probes.ReportingProbeType;
import com.dataiku.dip.metrics.probes.SQLProbeType;
import com.dataiku.dip.metrics.probes.TemporaryMetric;
import com.dataiku.dip.metrics.probes.VerifyDatasetColumnProbeType;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class Metric {
    public String type;
    public String id;
    public com.dataiku.dip.datasets.Type dataType;
    private static Map<String, MetricIdSerializer> idFactories = Maps.newHashMap();
    public static final char METRIC_PART_SEPARATOR = ':';

    public Metric(String type, com.dataiku.dip.datasets.Type dataType) {
        this.type = type;
        this.dataType = dataType;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public com.dataiku.dip.datasets.Type getDataType() {
        return this.dataType;
    }

    public Metric withType(String type) {
        this.type = type;
        return this;
    }

    public Metric withId(String id) {
        this.id = id;
        return this;
    }

    public Metric withDataType(com.dataiku.dip.datasets.Type dataType) {
        this.dataType = dataType;
        return this;
    }

    public abstract MetricMetadata getMeta();

    public abstract String getColumn();

    public abstract String getColumnInvariantId(String var1);

    public String getIdType() {
        return this.getType();
    }

    public static void registerMetricIdFactories() {
        idFactories.put("adv_col_stats", new AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetricSerializer());
        idFactories.put("basic", new BasicProbeType.BasicMetricSerializer());
        idFactories.put("col_stats", new BasicStatsDatasetProbeType.BasicStatsDatasetMetricSerializer());
        idFactories.put("percentile_stats", new PercentileStatsDatasetProbeType.PercentileStatsDatasetMetricSerializer());
        idFactories.put("check", new CheckProbeType.CheckMetricSerializer());
        idFactories.put("py_plugin", new CustomPythonProbeType.CustomPythonMetricSerializer());
        idFactories.put("sql_plugin", new CustomSQLProbeType.CustomSQLMetricSerializer());
        idFactories.put("external", new ExternalProbeType.ExternalMetricSerializer());
        idFactories.put("model_perf", new ModelPerformanceProbeType.ModelPerformanceMetricSerializer());
        idFactories.put("llm_evaluation", new LLMEvaluationProbeType.LLMEvaluationMetricSerializer());
        idFactories.put("partitioning", new PartitioningProbeType.PartitioningMetricSerializer());
        idFactories.put("python", new PythonProbeType.PythonMetricSerializer());
        idFactories.put("records", new RecordsProbeType.RecordsMetricSerializer());
        idFactories.put("reporting", new ReportingProbeType.ReportingMetricSerializer());
        idFactories.put("sql_query", new SQLProbeType.SQLMetricSerializer());
        idFactories.put("verify_col", new VerifyDatasetColumnProbeType.VerifyDatasetColumnMetricSerializer());
        idFactories.put("cell", new CellProbeType.CellMetricSerializer());
        idFactories.put("temporary_metrics_probe", new TemporaryMetric.TemporaryMetricIdSerializer());
    }

    public static String serializeMetric(Metric metric) {
        return idFactories.get(metric.getIdType()).serializeMetric(metric);
    }

    public static Metric deserializeMetric(String metricId) {
        String idType = metricId.substring(0, metricId.indexOf(58));
        return idFactories.get(idType).deserializeMetric(metricId);
    }

    public static String buildMetricIdFromParts(String ... parts) {
        ArrayList escapedParts = Lists.newArrayList();
        for (String part : parts) {
            escapedParts.add(part.replaceAll("\\:", "::"));
        }
        return Joiner.on((char)':').join((Iterable)escapedParts);
    }

    public static List<String> buildPartsFromMetricId(String metricId) {
        ArrayList parts = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < metricId.length()) {
            if (metricId.startsWith(String.valueOf(':'), i)) {
                int separatorCounter = 1;
                for (int j = i + 1; j < metricId.length() && metricId.startsWith(String.valueOf(':'), j); ++j) {
                    ++separatorCounter;
                }
                if (separatorCounter % 2 == 1) {
                    parts.add(sb.toString());
                    sb.setLength(0);
                }
                sb.append(String.valueOf(':').repeat(separatorCounter / 2));
                i += separatorCounter;
                continue;
            }
            sb.append(metricId.charAt(i));
            ++i;
        }
        if (!sb.isEmpty()) {
            parts.add(sb.toString());
        }
        return parts;
    }

    @Nullable
    public abstract Probe getMatchingProbe(List<Probe> var1);

    public boolean shouldBeSaved() {
        return true;
    }

    protected static Probe getProbeFromName(List<Probe> probes, String probeName) {
        return probes.stream().filter(probe -> probe.getMeta() != null && StringUtils.equals((CharSequence)probeName, (CharSequence)probe.getMeta().name)).findFirst().orElse(null);
    }

    public static void registerJsonAdapters() {
        Metric.registerMetricIdFactories();
        JSON.registerAdapter(Metric.class, (Object)new JSON.Adapter<Metric>(){

            public Metric deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject jsonObj = json.getAsJsonObject();
                String probeType = jsonObj.get("type").getAsString();
                if (probeType.equals("basic")) {
                    return (Metric)ctx.deserialize(json, BasicProbeType.BasicMetric.class);
                }
                if (probeType.equals("reporting")) {
                    return (Metric)ctx.deserialize(json, ReportingProbeType.ReportingMetric.class);
                }
                if (probeType.equals("model_perf")) {
                    return (Metric)ctx.deserialize(json, ModelPerformanceProbeType.ModelPerformanceMetric.class);
                }
                if (probeType.equals("llm_evaluation")) {
                    return (Metric)ctx.deserialize(json, LLMEvaluationProbeType.LLMEvaluationMetric.class);
                }
                if (probeType.equals("col_stats")) {
                    return (Metric)ctx.deserialize(json, BasicStatsDatasetProbeType.BasicStatsDatasetMetric.class);
                }
                if (probeType.equals("adv_col_stats")) {
                    return (Metric)ctx.deserialize(json, AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetric.class);
                }
                if (probeType.equals("percentile_stats")) {
                    return (Metric)ctx.deserialize(json, PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric.class);
                }
                if (probeType.equals("python")) {
                    return (Metric)ctx.deserialize(json, PythonProbeType.PythonMetric.class);
                }
                if (probeType.equals("sql_query")) {
                    return (Metric)ctx.deserialize(json, SQLProbeType.SQLMetric.class);
                }
                if (probeType.equals("partitioning")) {
                    return (Metric)ctx.deserialize(json, PartitioningProbeType.PartitioningMetric.class);
                }
                if (probeType.equals("verify_col")) {
                    return (Metric)ctx.deserialize(json, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetric.class);
                }
                if (probeType.equals("check")) {
                    return (Metric)ctx.deserialize(json, CheckProbeType.CheckMetric.class);
                }
                if (probeType.equals("external")) {
                    return (Metric)ctx.deserialize(json, ExternalProbeType.ExternalMetric.class);
                }
                if (probeType.startsWith("py_plugin")) {
                    return (Metric)ctx.deserialize(json, CustomPythonProbeType.CustomPythonMetric.class);
                }
                if (probeType.startsWith("sql_plugin")) {
                    return (Metric)ctx.deserialize(json, CustomSQLProbeType.CustomSQLMetric.class);
                }
                if (probeType.startsWith("records")) {
                    return (Metric)ctx.deserialize(json, RecordsProbeType.RecordsMetric.class);
                }
                if (probeType.startsWith("cell")) {
                    return (Metric)ctx.deserialize(json, CellProbeType.CellMetric.class);
                }
                if (probeType.startsWith("temporary_metrics_probe")) {
                    return (Metric)ctx.deserialize(json, TemporaryMetric.class);
                }
                throw new IllegalArgumentException("Unknown probe type of metric : " + probeType);
            }

            public JsonElement serialize(Metric metric, Type type, JsonSerializationContext ctx) {
                if (metric instanceof BasicProbeType.BasicMetric) {
                    return ctx.serialize((Object)metric, BasicProbeType.BasicMetric.class);
                }
                if (metric instanceof ReportingProbeType.ReportingMetric) {
                    return ctx.serialize((Object)metric, ReportingProbeType.ReportingMetric.class);
                }
                if (metric instanceof ModelPerformanceProbeType.ModelPerformanceMetric) {
                    return ctx.serialize((Object)metric, ModelPerformanceProbeType.ModelPerformanceMetric.class);
                }
                if (metric instanceof LLMEvaluationProbeType.LLMEvaluationMetric) {
                    return ctx.serialize((Object)metric, LLMEvaluationProbeType.LLMEvaluationMetric.class);
                }
                if (metric instanceof BasicStatsDatasetProbeType.BasicStatsDatasetMetric) {
                    return ctx.serialize((Object)metric, BasicStatsDatasetProbeType.BasicStatsDatasetMetric.class);
                }
                if (metric instanceof AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetric) {
                    return ctx.serialize((Object)metric, AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetric.class);
                }
                if (metric instanceof PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric) {
                    return ctx.serialize((Object)metric, PercentileStatsDatasetProbeType.PercentileStatsDatasetMetric.class);
                }
                if (metric instanceof PythonProbeType.PythonMetric) {
                    return ctx.serialize((Object)metric, PythonProbeType.PythonMetric.class);
                }
                if (metric instanceof SQLProbeType.SQLMetric) {
                    return ctx.serialize((Object)metric, SQLProbeType.SQLMetric.class);
                }
                if (metric instanceof PartitioningProbeType.PartitioningMetric) {
                    return ctx.serialize((Object)metric, PartitioningProbeType.PartitioningMetric.class);
                }
                if (metric instanceof VerifyDatasetColumnProbeType.VerifyDatasetColumnMetric) {
                    return ctx.serialize((Object)metric, VerifyDatasetColumnProbeType.VerifyDatasetColumnMetric.class);
                }
                if (metric instanceof CheckProbeType.CheckMetric) {
                    return ctx.serialize((Object)metric, CheckProbeType.CheckMetric.class);
                }
                if (metric instanceof ExternalProbeType.ExternalMetric) {
                    return ctx.serialize((Object)metric, ExternalProbeType.ExternalMetric.class);
                }
                if (metric instanceof RecordsProbeType.RecordsMetric) {
                    return ctx.serialize((Object)metric, RecordsProbeType.RecordsMetric.class);
                }
                if (metric instanceof CustomPythonProbeType.CustomPythonMetric) {
                    return ctx.serialize((Object)metric, CustomPythonProbeType.CustomPythonMetric.class);
                }
                if (metric instanceof CustomSQLProbeType.CustomSQLMetric) {
                    return ctx.serialize((Object)metric, CustomSQLProbeType.CustomSQLMetric.class);
                }
                if (metric instanceof CellProbeType.CellMetric) {
                    return ctx.serialize((Object)metric, CellProbeType.CellMetric.class);
                }
                if (metric instanceof TemporaryMetric) {
                    return ctx.serialize((Object)metric, TemporaryMetric.class);
                }
                return null;
            }
        });
    }

    public static interface MetricIdSerializer {
        public String serializeMetric(Metric var1);

        public Metric deserializeMetric(String var1);
    }
}

