/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class PythonMetricKernel
extends AbstractImpersonatedSecretProtectedPythonKernel<SingleCommandKernelLink> {
    private final APITicketService.Ticket ticket;

    public PythonMetricKernel(SingleCommandKernelLink link, APITicketService.Ticket ticket, String resourceFolderPath, String additionalPythonLibFolderPath, File tmpDir, String projectKey, AuthCtx authCtx, String envName) {
        super(link, GeneralSettingsDAO.CGrouppableProcessType.METRIC_CHECK, authCtx, tmpDir, resourceFolderPath, true, PythonMetricKernel.makePythonLibs("python-lib", additionalPythonLibFolderPath), projectKey, envName);
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    @Override
    protected String getPythonModule() {
        return "dataiku.metric.server";
    }

    public static class RunCheckResponse {
        public AbstractCheckContext.CheckOutcome outcome;
        public String message;
    }

    public static class RunCheckRequest {
        public final String command = "check";
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public MetricTargetType objectType;
        public String fullName;
        public String partitionId;
        public Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> lastValues;

        public RunCheckRequest(String code, JsonObject config, JsonObject pluginConfig, MetricTargetType objectType, String fullName, String partitionId, Map<String, ReadOnlyJobsInternalDB.MetricDataPoint> lastValues) {
            this.code = code;
            this.config = config;
            this.pluginConfig = pluginConfig;
            this.objectType = objectType;
            this.fullName = fullName;
            this.partitionId = partitionId;
            this.lastValues = lastValues;
        }
    }

    public static class ComputeMetricResponse {
        public Map<String, Object> result;
        public Map<String, String> types;
    }

    public static class ComputeMetricRequest {
        public final String command = "compute";
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public MetricTargetType objectType;
        public String fullName;
        public String partitionId;

        public ComputeMetricRequest(String code, JsonObject config, JsonObject pluginConfig, MetricTargetType objectType, String fullName, String partitionId) {
            this.code = code;
            this.config = config;
            this.pluginConfig = pluginConfig;
            this.objectType = objectType;
            this.fullName = fullName;
            this.partitionId = partitionId;
        }
    }
}

