/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MetricsQueryBuilder {
    public QueryBunch buildQuery(AuthCtx authCtx, MetricsQueryBuilderEngine engine, List<MetricComputation> computations, Map<String, String> alreadyComputed, String filter) throws Exception {
        SelectQueryBuilder queryBuilder;
        Dataset dataset = engine.getDataset();
        SQLDialect dialect = engine.getDialect();
        QueryBunch queryBunch = new QueryBunch();
        SelectQueryBuilder subQueryBuilder = MetricsQueryBuilder.getSelectQueryBuilder(authCtx, dataset, dialect, queryBunch);
        subQueryBuilder.select(new ExpressionBuilder.ExpressionBuilderFactory().col(subQueryBuilder.from().getAlias(), "*"));
        boolean requiresSubQuery = false;
        for (MetricComputation metricComputation : computations) {
            MetricsQueryBuilderAggregation computer = (MetricsQueryBuilderAggregation)((Object)metricComputation.computer);
            requiresSubQuery |= computer.addPreAggregations(authCtx, engine, metricComputation, dialect, subQueryBuilder, alreadyComputed);
        }
        if (requiresSubQuery) {
            queryBuilder = new SelectQueryBuilder();
            queryBuilder.from(subQueryBuilder, "inner");
        } else {
            queryBuilder = subQueryBuilder;
            queryBuilder.clearSelected();
        }
        for (MetricComputation computation : computations) {
            MetricsQueryBuilderAggregation computer = (MetricsQueryBuilderAggregation)((Object)computation.computer);
            computer.addAggregations(authCtx, engine, computation, dialect, queryBuilder, alreadyComputed);
        }
        ExpressionBuilder expressionBuilder = engine.getPartitionFilter();
        if (expressionBuilder != null) {
            queryBuilder.where(expressionBuilder);
        }
        if (StringUtils.isNotBlank((String)filter)) {
            queryBuilder.where(new ExpressionBuilder.ExpressionBuilderFactory().expr(filter));
        }
        queryBuilder.ensureAliasesMaxLength(30);
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        queryBunch.query = variablesService.getContext(dataset.getProjectKey()).expand(queryBuilder.toSQL(dialect));
        queryBunch.selectedItemsCount = queryBuilder.getSelectedItemsCount();
        return queryBunch;
    }

    public static SelectQueryBuilder getSelectQueryBuilder(AuthCtx authCtx, Dataset dataset, SQLDialect dialect, QueryBunch queryBunch) throws IOException {
        SelectQueryBuilder queryBuilder = new SelectQueryBuilder();
        if (DatasetInspector.isHive(dataset) || DatasetInspector.isSQLAble(authCtx, dataset) && !(dialect instanceof SparkSQLDialect)) {
            DatasetHandler.DatasetParams params = dataset.getParams();
            if (params instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
                AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
                if (config.mode.equals("query")) {
                    if (StringUtils.isBlank((String)config.query)) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset " + dataset.getFullName() + " is configured with mode 'SQL query' but the query is missing");
                    }
                    String datasetQuery = config.query;
                    Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
                    String[] statements = splitter.split(datasetQuery);
                    int selectStatementIndex = SQLUtils.findLastSelectStatement(statements, splitter);
                    selectStatementIndex = selectStatementIndex < 0 ? statements.length - 1 : selectStatementIndex;
                    for (int i = 0; i < selectStatementIndex; ++i) {
                        queryBunch.preQueries.add(statements[i]);
                    }
                    String query = statements[selectStatementIndex];
                    for (int i = selectStatementIndex + 1; i < statements.length; ++i) {
                        queryBunch.postQueries.add(statements[i]);
                    }
                    ArrayList columnNames = Lists.newArrayList((Iterable)Iterables.transform((Iterable)dataset.getSchema().getColumns(), SchemaColumn::getName));
                    QueryAst.TableLike table = queryBuilder.withInlineQuery(query, columnNames, "dku_subquery");
                    queryBuilder.from(table);
                } else if (config.mode.equals("table")) {
                    if (StringUtils.isBlank((String)config.table)) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table defined on SQL dataset " + dataset.getFullName());
                    }
                    queryBuilder.from(new SQLUtils.SQLTable(config.catalog, config.schema, config.table, true), "dku_datasource");
                }
            } else {
                SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
                queryBuilder.from(new SQLUtils.SQLTable(tableRef.getCatalog(), tableRef.getSchemaNullIfBlank(), tableRef.getTable(), true), "dku_datasource");
            }
        } else if (DatasetInspector.isHiveTable(dataset) || DatasetInspector.isHDFSDataset(dataset) && !(dialect instanceof SparkSQLDialect)) {
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
            queryBuilder.from(new SQLUtils.SQLTable(tableRef.getCatalog(), tableRef.getSchemaNullIfBlank(), tableRef.getTable(), true), "dku_datasource");
        } else if (dialect instanceof SparkSQLDialect) {
            queryBuilder.from(new SQLUtils.SQLTable(null, null, dataset.getProjectKey() + "_" + dataset.getName(), true), "dku_datasource");
        }
        return queryBuilder;
    }

    public static interface MetricsQueryBuilderEngine {
        public Dataset getDataset();

        public SQLDialect getDialect();

        public ExpressionBuilder getPartitionFilter();
    }

    public static interface MetricsQueryBuilderAggregation {
        default public boolean addPreAggregations(AuthCtx authCtx, MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) {
            return false;
        }

        public void addAggregations(AuthCtx var1, MetricsQueryBuilderEngine var2, MetricComputation var3, SQLDialect var4, SelectQueryBuilder var5, Map<String, String> var6) throws Exception;

        public String getAggregate(QueryRunResult var1, MetricComputation var2) throws Exception;
    }
}

