/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.Splitter;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public class ProbeQueryBuilder {
    public QueryBunch buildQuery(AuthCtx authCtx, ProbeQueryBuilderEngine engine, String query, Map<String, Object> probeVariables) throws Exception {
        ExpressionBuilder partitionFilter;
        SQLDialect dialect = engine.getDialect();
        HashMap variables = Maps.newHashMap();
        if (probeVariables != null) {
            for (Map.Entry<String, Object> probeVariable : probeVariables.entrySet()) {
                Object v = probeVariable.getValue();
                if (v instanceof List) {
                    ArrayList list = Lists.newArrayList();
                    for (Object o : (List)v) {
                        if (o instanceof String) {
                            list.add(dialect.quoteString((String)o));
                            continue;
                        }
                        list.add(o.toString());
                    }
                    variables.put(probeVariable.getKey(), Joiner.on((String)", ").join((Iterable)list));
                    continue;
                }
                variables.put(probeVariable.getKey(), v.toString());
            }
        }
        if ((partitionFilter = engine.getPartitionFilter()) != null) {
            String expression = partitionFilter.toSQL(dialect);
            variables.put("DKU_PARTITION_FILTER", expression);
            variables.put("DKU_PARTITION_FILTER_BLOCK", "(" + expression + ") AND ");
            variables.put("DKU_WHERE_PARTITION_FILTER", "WHERE (" + expression + ") ");
        } else {
            variables.put("DKU_PARTITION_FILTER", "");
            variables.put("DKU_PARTITION_FILTER_BLOCK", "");
            variables.put("DKU_WHERE_PARTITION_FILTER", "");
        }
        Dataset dataset = engine.getDataset();
        if (DatasetInspector.isHive(dataset) || DatasetInspector.isSQLAble(authCtx, dataset) && !(dialect instanceof SparkSQLDialect)) {
            DatasetHandler.DatasetParams params = dataset.getParams();
            if (params instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
                AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
                if (config.mode.equals("query")) {
                    if (StringUtils.isBlank((String)config.query)) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset " + dataset.getFullName() + " is configured with mode 'SQL query' but the query is missing");
                    }
                    String datasetQuery = config.query;
                    Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
                    String[] statements = splitter.split(datasetQuery);
                    int selectStatementIndex = SQLUtils.findLastSelectStatement(statements, splitter);
                    selectStatementIndex = selectStatementIndex < 0 ? statements.length - 1 : selectStatementIndex;
                    ArrayList preQueries = Lists.newArrayList();
                    ArrayList postQueries = Lists.newArrayList();
                    for (int i = 0; i < selectStatementIndex; ++i) {
                        preQueries.add(statements[i]);
                    }
                    String mainQuery = statements[selectStatementIndex];
                    for (int i = selectStatementIndex + 1; i < statements.length; ++i) {
                        postQueries.add(statements[i]);
                    }
                    variables.put("DKU_DATASET_PRE_QUERIES", Joiner.on((String)";\n").join((Iterable)preQueries));
                    variables.put("DKU_DATASET_POST_QUERIES", Joiner.on((String)";\n").join((Iterable)postQueries));
                    variables.put("DKU_DATASET_QUERY", mainQuery);
                } else if (config.mode.equals("table")) {
                    if (StringUtils.isBlank((String)config.table)) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "The table is not set for this SQL dataset");
                    }
                    variables.put("DKU_DATASET_TABLE_NAME", dialect.getQuotedTableFullName(config.catalog, config.schema, config.table));
                }
            } else {
                SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
                variables.put("DKU_DATASET_TABLE_NAME", dialect.getQuotedTableFullName(tableRef.getCatalog(), tableRef.getSchemaNullIfBlank(), tableRef.getTable()));
            }
        } else if (DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset)) {
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
            variables.put("DKU_DATASET_TABLE_NAME", dialect.getQuotedTableFullName(tableRef.getCatalog(), tableRef.getSchemaNullIfBlank(), tableRef.getTable()));
        } else if (dialect instanceof SparkSQLDialect) {
            variables.put("DKU_DATASET_TABLE_NAME", dialect.getQuotedTableFullName(null, null, dataset.getProjectKey() + "_" + dataset.getName()));
        }
        StrSubstitutor substitutor = new StrSubstitutor((Map)variables);
        query = substitutor.replace(query);
        return new QueryBunch(query);
    }

    public static interface ProbeQueryBuilderEngine {
        public Dataset getDataset();

        public SQLDialect getDialect();

        public ExpressionBuilder getPartitionFilter();
    }
}

