/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.csv.CSVDeserializer;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveProbeEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaProbeEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SQLProbeEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkProbeEngine;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Logger;

public class SQLProbeType
extends ProbeType
implements MetricBuilder {
    public static final String TYPE = "sql_query";
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.sql");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new MetricComputer.SQLQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                Dataset dataset;
                if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET && !probe.getConfigurationAs(SQLProbeConfiguration.class).isSingleAggregate() && DatasetInspector.isSQLAble(authCtx, dataset = (Dataset)object)) {
                    return new SQLProbeEngine.SQLProbeEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return SQLProbeType.TYPE;
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                SQLProbeConfiguration configuration = probe.getConfigurationAs(SQLProbeConfiguration.class);
                return configuration.getCode();
            }
        });
        computers.add(new SQLAggregateEngineComputer(new SQLProbeMetricsEngineComputer()));
        computers.add(new MetricComputer.HiveQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                Dataset dataset;
                if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET && !probe.getConfigurationAs(SQLProbeConfiguration.class).isSingleAggregate() && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset = (Dataset)object)) {
                    return new HiveProbeEngine.HiveProbeEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return SQLProbeType.TYPE;
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                SQLProbeConfiguration configuration = probe.getConfigurationAs(SQLProbeConfiguration.class);
                return configuration.getCode();
            }
        });
        computers.add(new HiveAggregateEngineComputer(new SQLProbeMetricsEngineComputer()));
        computers.add(new MetricComputer.ImpalaQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET) {
                    Dataset dataset = (Dataset)object;
                    SQLProbeConfiguration conf = probe.getConfigurationAs(SQLProbeConfiguration.class);
                    if (conf.getCanRunOnImpala() && !conf.isSingleAggregate() && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset) && SchemaUtils.isSafeForImpala(dataset)) {
                        return new ImpalaProbeEngine.ImpalaProbeEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                    }
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return SQLProbeType.TYPE;
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                SQLProbeConfiguration configuration = probe.getConfigurationAs(SQLProbeConfiguration.class);
                return configuration.getCode();
            }
        });
        computers.add(new ImpalaAggregateEngineComputer(new SQLProbeMetricsEngineComputer()));
        computers.add(new MetricComputer.SparkQueryEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET && !probe.getConfigurationAs(SQLProbeConfiguration.class).isSingleAggregate()) {
                    return new SparkProbeEngine.SparkProbeEngineRun().with(new MetricComputation(probe, this, metric, 3.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return SQLProbeType.TYPE;
            }

            @Override
            public String getQuery(Probe probe) throws IOException {
                SQLProbeConfiguration configuration = probe.getConfigurationAs(SQLProbeConfiguration.class);
                return configuration.getCode();
            }
        });
        computers.add(new SparkAggregateEngineComputer(new SQLProbeMetricsEngineComputer()));
        return computers;
    }

    public SQLProbeType() {
        this.type = TYPE;
    }

    private String getProbeName(Probe probe) {
        if (StringUtils.isNotBlank((String)probe.getMeta().getName())) {
            return probe.getMeta().getName();
        }
        SQLProbeConfiguration configuration = probe.getConfigurationAs(SQLProbeConfiguration.class);
        String code = configuration.getCode();
        String codeHash = DigestUtils.md5Hex((String)(code == null ? "" : code));
        return "h" + codeHash;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            SQLProbeHint probeHint = new SQLProbeHint();
            Dataset dataset = (Dataset)object;
            SQLProbeConfiguration configuration = probe.getConfigurationAs(SQLProbeConfiguration.class);
            HashSet aggregatedColumns = Sets.newHashSet(configuration.getColumns());
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                SQLProbeColumnHint columnHint = new SQLProbeColumnHint(column.getName());
                columnHint.metrics.add(new SQLProbeMetricHint("agg", aggregatedColumns.contains(column.getName()), false));
                probeHint.columns.add(columnHint);
            }
            return probeHint;
        }
        return null;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        SQLProbeConfiguration configuration = probe.getConfigurationAs(SQLProbeConfiguration.class);
        String primerMetricName = this.getProbeName(probe);
        if (configuration.singleAggregate && configuration.perColumn) {
            for (String configured : configuration.columns) {
                metrics.add(new SQLMetric(primerMetricName, configured, Type.STRING, this.getProbeName(probe)));
            }
        } else if (!forDisplay) {
            metrics.add(new SQLMetric(primerMetricName, null, Type.STRING, this.getProbeName(probe)));
        }
        return metrics;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> columns, Probe probe) {
        SQLProbeConfiguration probeConfiguration = probe.getConfigurationAs(SQLProbeConfiguration.class);
        if (probeConfiguration.perColumn && probeConfiguration.singleAggregate) {
            SQLProbeConfiguration configuration = new SQLProbeConfiguration();
            configuration.canRunOnImpala = probeConfiguration.canRunOnImpala;
            configuration.code = probeConfiguration.code;
            configuration.singleAggregate = probeConfiguration.singleAggregate;
            configuration.perColumn = probeConfiguration.perColumn;
            for (SchemaColumn column : columns) {
                configuration.columns.add(column.getName());
            }
            return configuration;
        }
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new SQLProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return SQLProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(9).withName("Custom SQL");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return true;
    }

    @Override
    public Metric build(String name, Type dataType, Probe probe) {
        return new SQLMetric(StringUtils.defaultIfEmpty((String)name, (String)"?unknown?"), null, dataType, this.getProbeName(probe));
    }

    public static class SQLAggregateEngineComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        private final SQLProbeMetricsEngineComputer subComputer;

        public SQLAggregateEngineComputer(SQLProbeMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            Dataset dataset;
            if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET && probe.getConfigurationAs(SQLProbeConfiguration.class).isSingleAggregate() && DatasetInspector.isSQLAble(authCtx, dataset = (Dataset)object)) {
                return new SQLMetricsEngine.SQLMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return SQLProbeType.TYPE;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            SQLProbeConfiguration configuration = computation.probe.getConfigurationAs(SQLProbeConfiguration.class);
            String code = configuration.getCode();
            this.subComputer.addAggregations(code, engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class SQLProbeMetricsEngineComputer {
        public ExpressionBuilder getAggregations(String code, SQLDialect dialect, ExpressionBuilder.ExpressionBuilderFactory ef, SQLMetric metric) {
            if (StringUtils.isNotBlank((String)metric.getColumn())) {
                HashMap replacement = Maps.newHashMap();
                replacement.put("column", metric.getColumn());
                StrSubstitutor substitutor = new StrSubstitutor((Map)replacement);
                code = substitutor.replace(code);
            }
            return ef.expr(code);
        }

        public void addAggregations(String code, Dataset dataset, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) throws Exception {
            SQLMetric metric = (SQLMetric)computation.metric;
            SQLProbeMetricsComputerSession session = new SQLProbeMetricsComputerSession();
            computation.session = session;
            session.dialect = dialect;
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            ExpressionBuilder expr = this.getAggregations(code, dialect, ef, metric);
            SelectQueryBuilder.SelectRefBuilder ref = queryBuilder.select(expr);
            session.offset = ref.getIndex();
        }

        public String getAggregate(SQLProbeMetricsComputerSession session, QueryRunResult rs2, int offset, SQLMetric metric) throws SQLException {
            Type dssType = rs2.columns.get((int)(offset - 1)).dssType;
            metric.updateWithQueryMetadata(metric.getColumn(), dssType);
            String v = rs2.rows.get(0)[offset - 1];
            try {
                if (dssType == Type.DATE) {
                    v = DKUtils.isoFormatReadableByDateFormat((long)CSVDeserializer.hiveDateParser.parseDateTime(v).getMillis());
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failure while trying to harmonize hive date to ISO format");
            }
            return v;
        }

        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            SQLProbeMetricsComputerSession session = (SQLProbeMetricsComputerSession)computation.session;
            return this.getAggregate(session, rs2, session.offset, (SQLMetric)computation.metric);
        }

        public static class SQLProbeMetricsComputerSession {
            public SQLDialect dialect;
            public int offset;
        }
    }

    public static class HiveAggregateEngineComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        private final SQLProbeMetricsEngineComputer subComputer;

        public HiveAggregateEngineComputer(SQLProbeMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            Dataset dataset;
            if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET && probe.getConfigurationAs(SQLProbeConfiguration.class).isSingleAggregate() && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset = (Dataset)object)) {
                return new HiveMetricsEngine.HiveMetricsEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return SQLProbeType.TYPE;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            SQLProbeConfiguration configuration = computation.probe.getConfigurationAs(SQLProbeConfiguration.class);
            String code = configuration.getCode();
            this.subComputer.addAggregations(code, engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class ImpalaAggregateEngineComputer
    extends MetricComputer.ImpalaMetricsEngineComputer {
        private final SQLProbeMetricsEngineComputer subComputer;

        public ImpalaAggregateEngineComputer(SQLProbeMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET && probe.getConfigurationAs(SQLProbeConfiguration.class).isSingleAggregate()) {
                Dataset dataset = (Dataset)object;
                SQLProbeConfiguration conf = probe.getConfigurationAs(SQLProbeConfiguration.class);
                if (conf.getCanRunOnImpala() && conf.isSingleAggregate() && DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset) && SchemaUtils.isSafeForImpala(dataset)) {
                    return new ImpalaMetricsEngine.ImpalaMetricsEngineRun("fakeColumnInCaseThereIsACountDistinct").with(new MetricComputation(probe, this, metric, 1.0));
                }
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return SQLProbeType.TYPE;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            SQLProbeConfiguration configuration = computation.probe.getConfigurationAs(SQLProbeConfiguration.class);
            String code = configuration.getCode();
            this.subComputer.addAggregations(code, engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class SparkAggregateEngineComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        private final SQLProbeMetricsEngineComputer subComputer;

        public SparkAggregateEngineComputer(SQLProbeMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof SQLMetric && objectType == MetricTargetType.DATASET && probe.getConfigurationAs(SQLProbeConfiguration.class).isSingleAggregate()) {
                return new SparkMetricsEngine.SparkMetricsEngineRun().with(new MetricComputation(probe, this, metric, 3.0));
            }
            return null;
        }

        @Override
        public String getProbeType() {
            return SQLProbeType.TYPE;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            SQLProbeConfiguration configuration = computation.probe.getConfigurationAs(SQLProbeConfiguration.class);
            String code = configuration.getCode();
            this.subComputer.addAggregations(code, engine.getDataset(), computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class SQLProbeConfiguration
    implements ProbeConfiguration {
        public String code;
        public boolean canRunOnImpala;
        public boolean singleAggregate = false;
        public boolean perColumn = false;
        public List<String> columns = Lists.newArrayList();

        public String getCode() {
            return this.code;
        }

        public boolean getCanRunOnImpala() {
            return this.canRunOnImpala;
        }

        public boolean isSingleAggregate() {
            return this.singleAggregate;
        }

        public boolean isPerColumn() {
            return this.perColumn;
        }

        public List<String> getColumns() {
            return this.columns;
        }
    }

    public static class SQLProbeHint {
        public List<SQLProbeColumnHint> columns = Lists.newArrayList();
    }

    public static class SQLProbeColumnHint {
        public String column;
        public List<SQLProbeMetricHint> metrics = Lists.newArrayList();

        SQLProbeColumnHint(String column) {
            this.column = column;
        }
    }

    public static class SQLProbeMetricHint {
        public String name;
        public boolean disabled;
        public boolean active;

        SQLProbeMetricHint(String name, boolean active, boolean disabled) {
            this.name = name;
            this.active = active;
            this.disabled = disabled;
        }
    }

    public static class SQLMetric
    extends Metric {
        public String name;
        public String column;
        public String probeName;

        public SQLMetric(String name, String column, Type resultDataType, String probeName) {
            super(SQLProbeType.TYPE, resultDataType);
            this.name = name;
            this.column = column;
            this.probeName = probeName;
            this.id = Metric.serializeMetric(this);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getColumn() {
            return this.column;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return new SQLMetric(this.name, placeholder, this.dataType, this.probeName).getId();
        }

        public String getProbeName() {
            return this.probeName;
        }

        @Override
        public MetricMetadata getMeta() {
            if (StringUtils.isNotBlank((String)this.column)) {
                return new MetricMetadata().withName(this.name + " on " + this.column + " (" + this.probeName + ")");
            }
            return new MetricMetadata().withName(this.name + " (" + this.probeName + ")");
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return SQLMetric.getProbeFromName(probes, this.getProbeName());
        }

        public void updateWithQueryMetadata(String column, Type type) {
            this.column = column;
            this.dataType = type;
            this.id = Metric.serializeMetric(this);
        }
    }

    public static class SQLMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof SQLMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            SQLMetric sqlMetric = (SQLMetric)metric;
            if (StringUtils.isNotBlank((String)sqlMetric.getColumn())) {
                return Metric.buildMetricIdFromParts(SQLProbeType.TYPE, sqlMetric.getName(), sqlMetric.getProbeName(), sqlMetric.getColumn());
            }
            return Metric.buildMetricIdFromParts(SQLProbeType.TYPE, sqlMetric.getName(), sqlMetric.getProbeName());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() == 3 && parts.get(0).equals(SQLProbeType.TYPE)) {
                return new SQLMetric(parts.get(1), null, Type.STRING, parts.get(2));
            }
            if (parts.size() == 4 && parts.get(0).equals(SQLProbeType.TYPE)) {
                return new SQLMetric(parts.get(1), parts.get(3), Type.STRING, parts.get(2));
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
        }
    }
}

