/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.nodeclients;

import com.dataiku.common.rpc.ProxyUserAPIClient;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.engine.DeploymentReport;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;

public abstract class AbstractDeployerClientProxyUser
extends ProxyUserAPIClient {
    AbstractDeployerClientProxyUser(GeneralSettingsDAO.DeployerRef ref, AuthCtx authCtx) {
        super(authCtx, ref.nodeUrl, ref.apiKey, ref.trustAllSSLCertificates);
    }

    protected String getPossibleBadInfraHint() {
        return ", please check URL of remote deployer (" + this.baseURI + ") or server version";
    }

    protected abstract String getPublicBaseUrl();

    protected abstract String getPublicPublishedItemUrl(String var1);

    private String getPublicDeploymentUrl(String deploymentId) {
        return this.getPublicBaseUrl() + "deployments/" + deploymentId;
    }

    abstract AbstractPublishedItemLightStatus getPublishedItemLightStatus(AbstractDeployment var1) throws IOException;

    private void checkPublishedPackageExists(AbstractDeployment deployment, String packageId) throws IOException {
        AbstractPublishedItemLightStatus lightStatus = this.getPublishedItemLightStatus(deployment);
        boolean packageExists = false;
        for (PublishedPackageInfo ppi : lightStatus.packages) {
            if (!packageId.equals(ppi.id)) continue;
            packageExists = true;
            break;
        }
        if (!packageExists) {
            throw new NotFoundException(String.format("Published package %s does not exist for %s", packageId, deployment.getPublishedItemId()));
        }
    }

    public void switchVersion(String deploymentId, String packageId) throws IOException {
        String getPath = this.getPublicDeploymentUrl(deploymentId) + "/settings";
        AbstractDeployment deployment = (AbstractDeployment)this.getForm(getPath, AbstractDeployment.class, new Object[0]);
        this.checkPublishedPackageExists(deployment, packageId);
        deployment.switchVersion(packageId);
        String savePath = this.getPublicDeploymentUrl(deployment.id) + "/settings?ignoreWarnings=true";
        this.putObject(savePath, Void.class, deployment);
    }

    <T extends DeploymentReport> FutureResponse<T> updateDeployment(String deploymentId, DeploymentUpdateRequest dur, TypeToken<FutureResponse<T>> answerTypeToken) throws IOException {
        dur.synchronous = true;
        String path = this.getPublicDeploymentUrl(deploymentId) + "/actions/update";
        return (FutureResponse)this.postObject(path, answerTypeToken, dur);
    }

    public InfoMessage.InfoMessages getGovernanceStatus(String deploymentId, String packageId) throws IOException {
        String path = this.getPublicDeploymentUrl(deploymentId) + "/governance-status";
        return (InfoMessage.InfoMessages)this.getForm(path, InfoMessage.InfoMessages.class, new Object[]{this.packageIdParameterName(), packageId});
    }

    protected abstract String packageIdParameterName();

    public static class DeploymentUpdateRequest {
        public boolean synchronous;
    }
}

